/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class CompiledVacuumModule
extends CompiledModule {
    public static final String NBT_XP_FLUID_TYPE = "XPFluidType";
    public static final String NBT_AUTO_EJECT = "AutoEject";
    private final boolean fastPickup = this.getAugmentCount((Item)ModItems.FAST_PICKUP_AUGMENT.get()) > 0;
    private final boolean xpMode = this.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0;
    private final boolean autoEjecting;
    private final FluidStack xpJuiceStack;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidReceiverCache = null;
    private int xpBuffered = 0;
    private final XPCollection.XPCollectionType xpCollectionType;

    public CompiledVacuumModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.getTagElement("modularrouters");
        if (compound != null) {
            Fluid xpFluid;
            this.xpCollectionType = XPCollection.getXPType(compound.getInt(NBT_XP_FLUID_TYPE));
            this.autoEjecting = compound.getBoolean(NBT_AUTO_EJECT);
            this.xpJuiceStack = this.xpMode ? ((xpFluid = this.xpCollectionType.getFluid()) == Fluids.EMPTY ? FluidStack.EMPTY : new FluidStack(xpFluid, 1000)) : FluidStack.EMPTY;
        } else {
            this.xpCollectionType = XPCollection.XPCollectionType.BOTTLE_O_ENCHANTING;
            this.autoEjecting = false;
            this.xpJuiceStack = FluidStack.EMPTY;
        }
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        if (this.xpMode) {
            return this.handleXpMode(router);
        }
        return this.handleItemMode(router);
    }

    @Override
    public void onNeighbourChange(ModularRouterBlockEntity router) {
        this.fluidReceiverCache = null;
    }

    @Override
    public List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        if (router == null) {
            return null;
        }
        ModuleItem.RelativeDirection dir = this.getDirection();
        int offset = dir == ModuleItem.RelativeDirection.NONE ? 0 : this.getRange() + 1;
        Direction facing = router.getAbsoluteFacing(dir);
        GlobalPos gPos = MiscUtil.makeGlobalPos(router.nonNullLevel(), router.getBlockPos().relative(facing, offset));
        return Collections.singletonList(new ModuleTarget(gPos, facing));
    }

    private boolean handleItemMode(ModularRouterBlockEntity router) {
        if (router.isBufferFull()) {
            return false;
        }
        ItemStack bufferStack = router.getBuffer().getStackInSlot(0);
        BlockPos centrePos = this.getTarget().gPos.pos();
        int range = this.getRange();
        List items = router.nonNullLevel().getEntitiesOfClass(ItemEntity.class, new AABB(centrePos).inflate((double)range));
        int toPickUp = this.getItemsPerTick(router);
        for (ItemEntity item : items) {
            if (!item.isAlive() || !this.fastPickup && item.hasPickUpDelay()) continue;
            ItemStack stackOnGround = item.getItem();
            if (!bufferStack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackOnGround, (ItemStack)bufferStack) || !this.getFilter().test(stackOnGround)) continue;
            int inRouter = bufferStack.getCount();
            int spaceInRouter = this.getRegulationAmount() > 0 ? Math.min(stackOnGround.getMaxStackSize(), this.getRegulationAmount()) - inRouter : stackOnGround.getMaxStackSize() - inRouter;
            ItemStack vacuumed = stackOnGround.split(Math.min(this.getItemsPerTick(router), spaceInRouter));
            ItemStack excess = router.insertBuffer(vacuumed);
            int remaining = excess == null ? 0 : excess.getCount();
            stackOnGround.grow(remaining);
            int inserted = vacuumed.getCount() - remaining;
            toPickUp -= inserted;
            if (stackOnGround.isEmpty()) {
                item.remove(Entity.RemovalReason.DISCARDED);
            }
            if (inserted > 0 && ((Boolean)ConfigHolder.common.module.vacuumParticles.get()).booleanValue() && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2) {
                ((ServerLevel)router.nonNullLevel()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, item.getX(), item.getY() + 0.25, item.getZ(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            if (toPickUp > 0) continue;
            break;
        }
        return toPickUp < this.getItemsPerTick(router);
    }

    private boolean handleXpMode(ModularRouterBlockEntity router) {
        ExperienceOrb orb;
        int spaceForXp;
        IFluidHandler fluidHandler = null;
        if (this.xpCollectionType.isSolid()) {
            ItemStack inRouterStack = router.getBufferItemStack();
            if (!inRouterStack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inRouterStack, (ItemStack)this.xpCollectionType.getIcon())) {
                return false;
            }
            spaceForXp = (inRouterStack.getMaxStackSize() - inRouterStack.getCount()) * this.xpCollectionType.getXpRatio();
        } else {
            fluidHandler = this.getFluidReceiver(router);
            if (fluidHandler == null) {
                fluidHandler = router.getFluidHandler();
            }
            spaceForXp = this.findSpaceForXPFluid(fluidHandler);
        }
        if (spaceForXp == 0) {
            return false;
        }
        List orbs = router.nonNullLevel().getEntitiesOfClass(ExperienceOrb.class, new AABB(this.getTarget().gPos.pos()).inflate((double)this.getRange()), Entity::isAlive);
        if (orbs.isEmpty()) {
            return false;
        }
        int initialSpaceForXp = spaceForXp;
        Iterator iterator = orbs.iterator();
        while (iterator.hasNext() && (orb = (ExperienceOrb)iterator.next()).getValue() <= spaceForXp) {
            if (this.xpCollectionType.isSolid()) {
                this.xpBuffered += orb.getValue();
                if (this.xpBuffered > this.xpCollectionType.getXpRatio()) {
                    int count = this.xpBuffered / this.xpCollectionType.getXpRatio();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.xpCollectionType.getIcon(), (int)count);
                    ItemStack excess = router.insertBuffer(stack);
                    this.xpBuffered -= stack.getCount() * this.xpCollectionType.getXpRatio();
                    if (!excess.isEmpty()) {
                        InventoryUtils.dropItems(router.nonNullLevel(), Vec3.atCenterOf((Vec3i)router.getBlockPos()), excess);
                    }
                }
            } else if (!this.doFluidXPFill(orb, fluidHandler)) {
                spaceForXp = 0;
            }
            spaceForXp -= orb.getValue();
            orb.remove(Entity.RemovalReason.DISCARDED);
        }
        return initialSpaceForXp - spaceForXp > 0;
    }

    private IFluidHandler getFluidReceiver(ModularRouterBlockEntity router) {
        Direction[] directionArray;
        if (!this.xpMode || this.xpJuiceStack.isEmpty() || !((directionArray = router.getLevel()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)directionArray;
        if (this.fluidReceiverCache == null) {
            for (Direction face : MiscUtil.DIRECTIONS) {
                BlockPos pos = router.getBlockPos().relative(face);
                IFluidHandler handler = (IFluidHandler)serverLevel.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)face.getOpposite());
                if (handler == null || handler.fill(this.xpJuiceStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                this.fluidReceiverCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)face.getOpposite(), () -> true, () -> {
                    this.fluidReceiverCache = null;
                });
                break;
            }
        }
        return this.fluidReceiverCache == null ? null : (IFluidHandler)this.fluidReceiverCache.getCapability();
    }

    private boolean doFluidXPFill(ExperienceOrb orb, @Nullable IFluidHandler xpHandler) {
        if (xpHandler == null) {
            return false;
        }
        FluidStack xpStack = new FluidStack(this.xpJuiceStack.getFluid(), orb.getValue() * this.xpCollectionType.getXpRatio() + this.xpBuffered);
        int filled = xpHandler.fill(xpStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled < xpStack.getAmount()) {
            this.xpBuffered = xpStack.getAmount() - filled;
            return false;
        }
        this.xpBuffered = 0;
        return true;
    }

    private int findSpaceForXPFluid(@Nullable IFluidHandler xpHandler) {
        int space = 0;
        if (xpHandler != null) {
            for (int idx = 0; idx < xpHandler.getTanks(); ++idx) {
                FluidStack fluidStack;
                if (!xpHandler.isFluidValid(idx, this.xpJuiceStack) || !(fluidStack = xpHandler.getFluidInTank(idx)).isEmpty() && fluidStack.getFluid() != this.xpCollectionType.getFluid()) continue;
                space += (xpHandler.getTankCapacity(idx) - fluidStack.getAmount()) / this.xpCollectionType.getXpRatio();
            }
        }
        return space;
    }

    public XPCollection.XPCollectionType getXPCollectionType() {
        return this.xpCollectionType;
    }

    public boolean isAutoEjecting() {
        return this.autoEjecting;
    }

    public boolean isXpMode() {
        return this.xpMode;
    }
}

