/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.network.messages.GuiSyncMessage;
import me.desht.modularrouters.network.messages.ItemBeamMessage;
import me.desht.modularrouters.network.messages.PushEntityMessage;
import me.desht.modularrouters.network.messages.RouterUpgradesSyncMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ClientPayloadHandler {
    public static void handleData(GuiSyncMessage message, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Screen patt921$temp = Minecraft.getInstance().screen;
            if (patt921$temp instanceof IResyncableGui) {
                IResyncableGui syncable = (IResyncableGui)patt921$temp;
                syncable.resync(message.newStack());
            }
        });
    }

    public static void handleData(ItemBeamMessage message, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> Minecraft.getInstance().level.getBlockEntity(message.pos(), ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(te -> message.beams().forEach(te::addItemBeam)));
    }

    public static void handleData(PushEntityMessage message, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(message.entityId());
            if (entity != null) {
                Vec3 vec = message.vec();
                entity.setDeltaMovement(vec.x, vec.y, vec.z);
                entity.horizontalCollision = false;
                entity.verticalCollision = false;
                if (entity instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)entity;
                    l.setJumping(true);
                }
            }
        });
    }

    public static void handleData(RouterUpgradesSyncMessage message, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && level.isLoaded(message.pos())) {
                level.getBlockEntity(message.pos(), ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> router.setUpgradesFrom((IItemHandler)message.upgradesHandler()));
            }
        });
    }
}

