/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.Objects;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.BulkItemFilterMenu;
import me.desht.modularrouters.container.FilterSlot;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import me.desht.modularrouters.network.messages.FilterSettingsMessage;
import me.desht.modularrouters.network.messages.GuiSyncMessage;
import me.desht.modularrouters.network.messages.ModuleFilterMessage;
import me.desht.modularrouters.network.messages.ModuleSettingsMessage;
import me.desht.modularrouters.network.messages.OpenGuiMessage;
import me.desht.modularrouters.network.messages.SyncUpgradeSettingsMessage;
import me.desht.modularrouters.network.messages.ValidateModuleMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(FilterSettingsMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            MFLocator locator = message.locator();
            ItemStack moduleStack = locator.getModuleStack((Player)player);
            ItemStack filterStack = locator.getTargetItem((Player)player);
            Item patt1555$temp = filterStack.getItem();
            if (patt1555$temp instanceof SmartFilterItem) {
                SmartFilterItem sf = (SmartFilterItem)patt1555$temp;
                context.workHandler().submitAsync(() -> {
                    GuiSyncMessage response = sf.onReceiveSettingsMessage((Player)player, message, filterStack, moduleStack);
                    if (!moduleStack.isEmpty()) {
                        ModularRouterBlockEntity router = locator.getRouter(player.level()).orElse(null);
                        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, router);
                        filterHandler.setStackInSlot(locator.filterSlot(), filterStack);
                        filterHandler.save();
                        if (locator.hand() != null) {
                            player.setItemInHand(locator.hand(), filterHandler.getHolderStack());
                        } else if (router != null) {
                            router.recompileNeeded(1);
                        }
                    }
                    if (response != null) {
                        PacketDistributor.TargetPoint tp = new PacketDistributor.TargetPoint(player.getX(), player.getY(), player.getZ(), 64.0, player.getCommandSenderWorld().dimension());
                        PacketDistributor.NEAR.with((Object)tp).send(new CustomPacketPayload[]{response});
                    }
                });
            }
        }));
    }

    public static void handleData(ModuleFilterMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            AbstractContainerMenu c = player.containerMenu;
            int slot = message.slot();
            if (ServerPayloadHandler.isValidContainer(c) && slot >= 0 && slot < c.slots.size() && c.getSlot(slot) instanceof FilterSlot) {
                c.getSlot(slot).set(message.stack());
            }
        }));
    }

    private static boolean isValidContainer(AbstractContainerMenu c) {
        return c instanceof ModuleMenu || c instanceof BulkItemFilterMenu;
    }

    public static void handleData(ModuleSettingsMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            MFLocator locator = message.locator();
            CompoundTag payload = message.payload();
            ItemStack moduleStack = locator.getModuleStack((Player)player);
            if (moduleStack.getItem() instanceof ModuleItem) {
                CompoundTag compound = ModuleHelper.validateNBTForWriting(moduleStack);
                for (String key : payload.getAllKeys()) {
                    compound.put(key, Objects.requireNonNull(payload.get(key)));
                }
                if (locator.routerPos() != null) {
                    player.getCommandSenderWorld().getBlockEntity(locator.routerPos(), ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> router.recompileNeeded(1));
                }
            } else {
                ModularRouters.LOGGER.warn("ignoring ModuleSettingsMessage for " + player.getGameProfile().getName() + " - expected module not found @ " + locator);
            }
        }));
    }

    public static void handleData(OpenGuiMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            MFLocator locator = message.locator();
            switch (message.op()) {
                case ROUTER: {
                    locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)router, locator.routerPos()));
                    break;
                }
                case MODULE_HELD: {
                    player.openMenu((MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, locator), locator::writeBuf);
                    break;
                }
                case MODULE_INSTALLED: {
                    locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, locator), locator::writeBuf));
                    break;
                }
                case FILTER_HELD: {
                    player.openMenu((MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, locator), locator::writeBuf);
                    break;
                }
                case FILTER_INSTALLED: {
                    locator.getRouter(player.getCommandSenderWorld()).ifPresent(router -> player.openMenu((MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, locator), locator::writeBuf));
                }
            }
        }));
    }

    public static void handleData(SyncUpgradeSettingsMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            ItemStack held = player.getItemInHand(message.hand());
            if (held.getItem() instanceof SyncUpgrade) {
                SyncUpgrade.setTunedValue(held, message.tunedValue());
            }
        }));
    }

    public static void handleData(ValidateModuleMessage message, PlayPayloadContext context) {
        context.player().ifPresent(player -> context.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemInHand(message.hand());
            Item patt7159$temp = stack.getItem();
            if (patt7159$temp instanceof ModuleItem) {
                ModuleItem moduleItem = (ModuleItem)patt7159$temp;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    moduleItem.doModuleValidation(stack, sp);
                }
            }
        }));
    }
}

