/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ItemBeamMessage(BlockPos pos, List<BeamData> beams) implements CustomPacketPayload
{
    public static final ResourceLocation ID = MiscUtil.RL("item_beam");

    public ItemBeamMessage(BlockEntity te, List<BeamData> beams) {
        this(te.getBlockPos(), List.copyOf(beams));
    }

    public static ItemBeamMessage fromNetwork(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        ImmutableList.Builder builder = ImmutableList.builder();
        int n = buf.readVarInt();
        for (int i = 0; i < n; ++i) {
            builder.add((Object)new BeamData(buf, pos));
        }
        ImmutableList beams = builder.build();
        return new ItemBeamMessage(pos, (List<BeamData>)beams);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.beams.size());
        this.beams.forEach(beam -> beam.toBytes(buf, this.pos));
    }

    public ResourceLocation id() {
        return ID;
    }
}

