/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public record RouterUpgradesSyncMessage(BlockPos pos, ItemStackHandler upgradesHandler) implements CustomPacketPayload
{
    public static final ResourceLocation ID = MiscUtil.RL("router_upgrades_sync");

    public RouterUpgradesSyncMessage(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), RouterUpgradesSyncMessage.createHandler(buf.readNbt()));
    }

    public static RouterUpgradesSyncMessage forRouter(ModularRouterBlockEntity router) {
        BlockPos pos = router.getBlockPos();
        IItemHandler h = router.getUpgrades();
        ItemStackHandler handler = new ItemStackHandler(h.getSlots());
        for (int i = 0; i < h.getSlots(); ++i) {
            handler.setStackInSlot(i, h.getStackInSlot(i).copy());
        }
        return new RouterUpgradesSyncMessage(pos, handler);
    }

    private static ItemStackHandler createHandler(CompoundTag tag) {
        ItemStackHandler h = new ItemStackHandler();
        h.deserializeNBT(tag);
        return h;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbt((Tag)this.upgradesHandler.serializeNBT());
    }

    public ResourceLocation id() {
        return ID;
    }
}

