/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.recipe;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModRecipes;
import me.desht.modularrouters.item.module.IPickaxeUser;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ToolActions;
import org.apache.commons.lang3.Validate;

public abstract class PickaxeModuleRecipe
extends ShapelessRecipe {
    PickaxeModuleRecipe(String name, ItemStack result, NonNullList<Ingredient> ingredients, CraftingBookCategory category) {
        super(name, category, result, ingredients);
        Validate.isTrue((boolean)(result.getItem() instanceof IPickaxeUser), (String)("recipe " + name + ": result is not a IPickaxeUser!"), (Object[])new Object[0]);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        if (!super.matches(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!PickaxeModuleRecipe.isValidPickaxe(stack) && !(stack.getItem() instanceof IPickaxeUser)) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack pick = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (PickaxeModuleRecipe.isValidPickaxe(stack)) {
                pick = stack;
                break;
            }
            Item item = stack.getItem();
            if (!(item instanceof IPickaxeUser)) continue;
            IPickaxeUser pickaxeUser = (IPickaxeUser)item;
            pick = pickaxeUser.getPickaxe(stack);
            break;
        }
        if (!pick.isEmpty()) {
            ItemStack result = super.assemble(inv, registryAccess);
            return ((IPickaxeUser)result.getItem()).setPickaxe(result, pick);
        }
        return ItemStack.EMPTY;
    }

    private static boolean isValidPickaxe(ItemStack stack) {
        return stack != null && stack.getItem().canPerformAction(stack, ToolActions.PICKAXE_DIG) && stack.getDamageValue() == 0;
    }

    private static class PickaxeIngredient
    extends Ingredient {
        PickaxeIngredient() {
            super(Stream.of(new Ingredient.TagValue(ItemTags.PICKAXES)));
        }

        public boolean test(@Nullable ItemStack stack) {
            return PickaxeModuleRecipe.isValidPickaxe(stack);
        }
    }

    public static class ExtruderModule1Recipe
    extends PickaxeModuleRecipe {
        public ExtruderModule1Recipe(CraftingBookCategory category) {
            super("modularrouters:extruder1", new ItemStack((ItemLike)ModItems.EXTRUDER_MODULE_1.get()), ExtruderModule1Recipe.ingredients(), category);
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_MODULE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PLACER_MODULE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BREAKER_MODULE.get()})});
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)ModRecipes.EXTRUDER_MODULE_1.get();
        }
    }

    public static class BreakerModuleRecipe
    extends PickaxeModuleRecipe {
        public BreakerModuleRecipe(CraftingBookCategory category) {
            super("modularrouters:breaker", new ItemStack((ItemLike)ModItems.BREAKER_MODULE.get()), BreakerModuleRecipe.ingredients(), category);
        }

        private static NonNullList<Ingredient> ingredients() {
            return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_MODULE.get()}), new PickaxeIngredient()});
        }

        public RecipeSerializer<?> getSerializer() {
            return (RecipeSerializer)ModRecipes.BREAKER_MODULE.get();
        }
    }
}

