/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.recipe;

import me.desht.modularrouters.core.ModRecipes;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ResetModuleRecipe
extends CustomRecipe {
    public ResetModuleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, Level wrldIn) {
        ModuleItem module = null;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (module != null || !(stack.getItem() instanceof ModuleItem)) {
                return false;
            }
            module = (ModuleItem)stack.getItem();
        }
        return module != null;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack moduleStack = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof ModuleItem)) continue;
            moduleStack = stack;
            break;
        }
        if (!moduleStack.isEmpty()) {
            IPickaxeUser pickaxeUser;
            ItemStack pick;
            ItemStack newStack = new ItemStack((ItemLike)moduleStack.getItem());
            Item item = moduleStack.getItem();
            if (item instanceof IPickaxeUser && !(pick = (pickaxeUser = (IPickaxeUser)item).getPickaxe(moduleStack)).isEmpty()) {
                pickaxeUser.setPickaxe(newStack, pick);
            }
            return newStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.MODULE_RESET.get();
    }
}

