/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeamData {
    private final BlockPos dest;
    private final int color;
    private final int duration;
    private final ItemStack stack;
    private boolean itemFade;
    private boolean reversed;
    private int ticksLived = 0;

    public BeamData(int duration, BlockPos dest, ItemStack stack, int color) {
        this.duration = duration;
        this.dest = dest;
        this.stack = stack;
        this.color = color;
    }

    public BeamData(int duration, BlockPos dest, int color) {
        this.duration = duration;
        this.dest = dest;
        this.stack = ItemStack.EMPTY;
        this.color = color;
    }

    public BeamData(FriendlyByteBuf buf, BlockPos pos1) {
        byte x = buf.readByte();
        byte y = buf.readByte();
        byte z = buf.readByte();
        this.dest = pos1.offset((int)(-x), (int)(-y), (int)(-z));
        this.color = buf.readInt();
        this.duration = buf.readVarInt();
        this.stack = buf.readItem();
        if (!this.stack.isEmpty()) {
            this.itemFade = buf.readBoolean();
            this.reversed = buf.readBoolean();
        }
    }

    public void toBytes(FriendlyByteBuf buf, BlockPos pos1) {
        buf.writeByte(pos1.getX() - this.dest.getX());
        buf.writeByte(pos1.getY() - this.dest.getY());
        buf.writeByte(pos1.getZ() - this.dest.getZ());
        buf.writeInt(this.color);
        buf.writeVarInt(this.duration);
        buf.writeItem(this.stack);
        if (!this.stack.isEmpty()) {
            buf.writeBoolean(this.itemFade);
            buf.writeBoolean(this.reversed);
        }
    }

    public BeamData reverseItems() {
        this.reversed = true;
        return this;
    }

    public BeamData fadeItems() {
        this.itemFade = true;
        return this;
    }

    public Vec3 getStart(Vec3 basePos) {
        return this.reversed ? Vec3.atCenterOf((Vec3i)this.dest) : basePos;
    }

    public Vec3 getEnd(Vec3 basePos) {
        return this.reversed ? basePos : Vec3.atCenterOf((Vec3i)this.dest);
    }

    public AABB getAABB(BlockPos basePos) {
        return AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)basePos, (Vec3i)this.dest));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isItemFade() {
        return this.itemFade;
    }

    public float getProgress(float partialTicks) {
        return Mth.clamp((float)(((float)(this.ticksLived - 1) + partialTicks) / (float)this.duration), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        ++this.ticksLived;
    }

    public boolean isExpired() {
        return this.ticksLived > this.duration;
    }

    public int[] getRGB() {
        int[] res = new int[]{this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF};
        return res;
    }
}

