/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.CustomEntityPlaceEvent;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.fake_player.RouterFakePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockUtil {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    private static BlockState getPlaceableState(BlockPlaceContext ctx) {
        try {
            BlockState res = null;
            Level world = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            Item item = ctx.getItemInHand().getItem();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).getBlock();
                res = block.getStateForPlacement(ctx);
            } else if (item instanceof IPlantable) {
                res = ((IPlantable)item).getPlant((BlockGetter)world, pos);
            } else if (item == Items.COCOA_BEANS) {
                res = BlockUtil.getCocoaBeanState(ctx);
            }
            if (res != null && !res.canSurvive((LevelReader)world, pos)) {
                res = null;
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static BlockState getCocoaBeanState(BlockPlaceContext ctx) {
        if (ctx.getPlayer() == null) {
            return null;
        }
        for (Direction f : HORIZONTALS) {
            BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos().relative(f));
            if (state.getBlock() != Blocks.JUNGLE_LOG) continue;
            ctx.getPlayer().setYRot(BlockUtil.getYawFromFacing(f));
            return Blocks.COCOA.getStateForPlacement(ctx);
        }
        return null;
    }

    private static float getYawFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.WEST -> 90.0f;
            case Direction.NORTH -> 180.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }

    public static BlockState tryPlaceAsBlock(ModularRouterBlockEntity router, ItemStack toPlace, Level world, BlockPos pos, Direction facing) {
        BlockState currentState = world.getBlockState(pos);
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.setYRot(BlockUtil.getYawFromFacing(facing));
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, toPlace);
        float hitX = (float)(fakePlayer.getX() - (double)pos.getX());
        float hitY = (float)(fakePlayer.getY() - (double)pos.getY());
        float hitZ = (float)(fakePlayer.getZ() - (double)pos.getZ());
        BlockHitResult brtr = new BlockHitResult(new Vec3((double)hitX, (double)hitY, (double)hitZ), facing, pos, false);
        BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
        if (!currentState.canBeReplaced(ctx)) {
            return null;
        }
        BlockState newState = BlockUtil.getPlaceableState(ctx);
        if (newState != null) {
            BlockSnapshot snap = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos);
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, toPlace);
            CustomEntityPlaceEvent event = new CustomEntityPlaceEvent(snap, Blocks.AIR.defaultBlockState(), (Entity)fakePlayer, newState);
            NeoForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled() && world.setBlockAndUpdate(pos, newState)) {
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                BlockItem.updateCustomBlockEntityTag((Level)world, (Player)fakePlayer, (BlockPos)pos, (ItemStack)toPlace);
                newState.getBlock().setPlacedBy(world, pos, newState, (LivingEntity)fakePlayer, toPlace);
                return newState;
            }
        }
        return null;
    }

    public static boolean tryPlaceBlock(ModularRouterBlockEntity router, BlockState newState, Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel) || !world.getBlockState(pos).canBeReplaced()) {
            return false;
        }
        BlockSnapshot snap = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos);
        CustomEntityPlaceEvent event = new CustomEntityPlaceEvent(snap, Blocks.AIR.defaultBlockState(), (Entity)router.getFakePlayer(), newState);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled() && world.setBlockAndUpdate(pos, newState);
    }

    public static BreakResult tryBreakBlock(ModularRouterBlockEntity router, Level world, BlockPos pos, Filter filter, ItemStack pickaxe, boolean matchByBlock) {
        Tiers tier;
        if (!(world instanceof ServerLevel)) {
            return BreakResult.NOT_BROKEN;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.isAir() || state.getDestroySpeed((BlockGetter)world, pos) < 0.0f || block instanceof LiquidBlock || matchByBlock && !filter.test(new ItemStack((ItemLike)block))) {
            return BreakResult.NOT_BROKEN;
        }
        RouterFakePlayer fakePlayer = router.getFakePlayer();
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        Item item = pickaxe.getItem();
        if (item instanceof TieredItem) {
            TieredItem t = (TieredItem)item;
            v0 = t.getTier();
        } else {
            v0 = tier = Tiers.STONE;
        }
        if (((Boolean)ConfigHolder.common.module.breakerHarvestLevelLimit.get()).booleanValue() && !TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state)) {
            return BreakResult.NOT_BROKEN;
        }
        List allDrops = Block.getDrops((BlockState)world.getBlockState(pos), (ServerLevel)serverWorld, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)fakePlayer, (ItemStack)pickaxe);
        Map<Boolean, List<ItemStack>> groups = allDrops.stream().collect(Collectors.partitioningBy(matchByBlock ? s -> true : filter));
        if (!matchByBlock && allDrops.isEmpty() && !filter.isEmpty() && !filter.isBlacklist()) {
            return BreakResult.NOT_BROKEN;
        }
        if (allDrops.isEmpty() || !groups.get(true).isEmpty()) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, state, (Player)fakePlayer);
            NeoForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                world.removeBlock(pos, false);
                if (((Boolean)ConfigHolder.common.router.blockBreakXPDrops.get()).booleanValue() && breakEvent.getExpToDrop() > 0) {
                    Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
                    ExperienceOrb xpOrb = new ExperienceOrb(world, vec.x, vec.y, vec.z, breakEvent.getExpToDrop());
                    world.addFreshEntity((Entity)xpOrb);
                }
                return new BreakResult(true, groups);
            }
        }
        return BreakResult.NOT_BROKEN;
    }

    public static String getBlockName(Level w, BlockPos pos) {
        return w == null ? "" : w.getBlockState(pos).getBlock().getDescriptionId();
    }

    public static class BreakResult {
        static final BreakResult NOT_BROKEN = new BreakResult(false, Collections.emptyMap());
        private final boolean blockBroken;
        private final Map<Boolean, List<ItemStack>> drops;

        BreakResult(boolean blockBroken, Map<Boolean, List<ItemStack>> drops) {
            this.blockBroken = blockBroken;
            this.drops = drops;
        }

        public boolean isBlockBroken() {
            return this.blockBroken;
        }

        List<ItemStack> getFilteredDrops(boolean passed) {
            return this.drops.getOrDefault(passed, Collections.emptyList());
        }

        public void processDrops(Level world, BlockPos pos, IItemHandler handler) {
            for (ItemStack drop : this.getFilteredDrops(true)) {
                ItemStack excess = handler.insertItem(0, drop, false);
                if (excess.isEmpty()) continue;
                InventoryUtils.dropItems(world, Vec3.atCenterOf((Vec3i)pos), excess);
            }
            for (ItemStack drop : this.getFilteredDrops(false)) {
                InventoryUtils.dropItems(world, Vec3.atCenterOf((Vec3i)pos), drop);
            }
        }
    }
}

