/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;

public record MFLocator(InteractionHand hand, BlockPos routerPos, int routerSlot, int filterSlot, ItemType itemType) {
    private static MFLocator create(ItemType itemType, InteractionHand hand, BlockPos routerPos, int routerSlot, int filterSlot) {
        Validate.isTrue((hand != null || routerPos != null && routerSlot >= 0 ? 1 : 0) != 0);
        return new MFLocator(hand, routerPos, routerSlot, filterSlot, itemType);
    }

    public static MFLocator heldModule(InteractionHand hand) {
        return MFLocator.create(ItemType.MODULE, hand, null, -1, -1);
    }

    public static MFLocator heldFilter(InteractionHand hand) {
        return MFLocator.create(ItemType.FILTER, hand, null, -1, -1);
    }

    public static MFLocator moduleInRouter(BlockPos routerPos, int routerSlot) {
        return MFLocator.create(ItemType.MODULE, null, routerPos, routerSlot, -1);
    }

    public static MFLocator filterInHeldModule(InteractionHand hand, int filterSlot) {
        return MFLocator.create(ItemType.FILTER, hand, null, -1, filterSlot);
    }

    public static MFLocator filterInInstalledModule(BlockPos routerPos, int routerSlot, int filterSlot) {
        return MFLocator.create(ItemType.FILTER, null, routerPos, routerSlot, filterSlot);
    }

    public static MFLocator fromBuffer(FriendlyByteBuf buf) {
        ItemType type = (ItemType)buf.readEnum(ItemType.class);
        InteractionHand hand = null;
        BlockPos routerPos = null;
        int routerSlot = -1;
        if (buf.readBoolean()) {
            routerPos = buf.readBlockPos();
            routerSlot = buf.readByte();
        } else {
            hand = (InteractionHand)buf.readEnum(InteractionHand.class);
        }
        byte filterSlot = buf.readByte();
        return MFLocator.create(type, hand, routerPos, routerSlot, filterSlot);
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.itemType);
        buf.writeBoolean(this.routerPos != null);
        if (this.routerPos != null) {
            buf.writeBlockPos(this.routerPos);
            buf.writeByte(this.routerSlot);
        } else {
            buf.writeEnum((Enum)this.hand);
        }
        buf.writeByte(this.filterSlot);
    }

    @Nonnull
    public ItemStack getTargetItem(Player player) {
        if (this.itemType == ItemType.MODULE) {
            if (this.hand != null) {
                return player.getItemInHand(this.hand).getItem() instanceof ModuleItem ? player.getItemInHand(this.hand) : ItemStack.EMPTY;
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getInstalledModule(player.level());
            }
        } else if (this.itemType == ItemType.FILTER) {
            if (this.hand != null) {
                return this.getFilterForStack(player.getItemInHand(this.hand));
            }
            if (this.routerPos != null && this.routerSlot >= 0) {
                return this.getFilterForStack(this.getInstalledModule(player.level()));
            }
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack getModuleStack(Player player) {
        if (this.hand != null) {
            return player.getItemInHand(this.hand).getItem() instanceof ModuleItem ? player.getItemInHand(this.hand) : ItemStack.EMPTY;
        }
        if (this.routerPos != null) {
            return this.getInstalledModule(player.level());
        }
        return ItemStack.EMPTY;
    }

    public Optional<ModularRouterBlockEntity> getRouter(Level world) {
        return this.routerPos == null ? Optional.empty() : world.getBlockEntity(this.routerPos, ModBlockEntities.MODULAR_ROUTER.get());
    }

    @Nonnull
    private ItemStack getInstalledModule(Level world) {
        return this.getRouter(world).map(router -> router.getModules().getStackInSlot(this.routerSlot)).orElse(ItemStack.EMPTY);
    }

    @Nonnull
    private ItemStack getFilterForStack(@Nonnull ItemStack stack) {
        if (stack.getItem() instanceof SmartFilterItem) {
            return stack;
        }
        if (stack.getItem() instanceof ModuleItem && this.filterSlot >= 0) {
            return new BaseModuleHandler.ModuleFilterHandler(stack, null).getStackInSlot(this.filterSlot);
        }
        return ItemStack.EMPTY;
    }

    public static enum ItemType {
        MODULE,
        FILTER;

    }
}

