/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import com.mojang.serialization.DynamicOps;
import java.text.NumberFormat;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class MiscUtil {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static MutableComponent asMutableComponent(Component component) {
        MutableComponent m;
        return component instanceof MutableComponent ? (m = (MutableComponent)component) : component.copy();
    }

    public static String commify(int n) {
        return NumberFormat.getNumberInstance().format(n);
    }

    public static String locToString(ResourceLocation dim, BlockPos pos) {
        String s = dim.getNamespace().equals("minecraft") ? dim.getPath() : dim.toString();
        return String.format("%s [%d,%d,%d]", s, pos.getX(), pos.getY(), pos.getZ());
    }

    public static String locToString(GlobalPos pos) {
        return MiscUtil.locToString(pos.dimension().location(), pos.pos());
    }

    public static ResourceLocation RL(String name) {
        return new ResourceLocation("modularrouters", name);
    }

    public static int getYawFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 180;
            case Direction.WEST -> 90;
            case Direction.EAST -> -90;
            default -> 0;
        };
    }

    public static Component settingsStr(String prefix, Component c) {
        return Component.literal((String)prefix).append(c);
    }

    public static Tag serializeGlobalPos(GlobalPos globalPos) {
        return (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)globalPos).result().orElseThrow();
    }

    public static GlobalPos deserializeGlobalPos(CompoundTag tag) {
        return (GlobalPos)GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().orElseThrow();
    }

    @CheckForNull
    public static ServerLevel getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().getLevel(pos.dimension());
    }

    public static GlobalPos makeGlobalPos(Level w, BlockPos pos) {
        return GlobalPos.of((ResourceKey)w.dimension(), (BlockPos)pos);
    }

    public static boolean blockHasSolidSide(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return Block.isFaceFull((VoxelShape)state.getBlockSupportShape(worldIn, pos), (Direction)side);
    }

    public static Set<TagKey<Item>> itemTags(Item item) {
        return item.builtInRegistryHolder().tags().collect(Collectors.toSet());
    }

    public static Set<TagKey<Fluid>> fluidTags(Fluid fluid) {
        return fluid.builtInRegistryHolder().tags().collect(Collectors.toSet());
    }

    public static boolean sameItemStackIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isDamageableItem()) {
            return stack1.is(stack2.getItem());
        }
        return !stack2.isEmpty() && stack1.is(stack2.getItem());
    }
}

