/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import javax.annotation.Nonnull;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModuleHelper {
    public static final String NBT_DIRECTION = "Direction";
    public static final String NBT_REDSTONE_MODE = "RedstoneMode";
    public static final String NBT_REGULATOR_AMOUNT = "RegulatorAmount";
    public static final String NBT_FILTER = "ModuleFilter";
    public static final String NBT_AUGMENTS = "Augments";
    public static final String NBT_MATCH_ALL = "MatchAll";
    public static final String NBT_TERMINATION = "Termination";
    private static final String NBT_RR_COUNTER = "RoundRobinCounter";

    @Nonnull
    public static CompoundTag validateNBT(ItemStack stack) {
        return stack.hasTag() ? stack.getTag().getCompound("modularrouters") : new CompoundTag();
    }

    @Nonnull
    public static CompoundTag validateNBTForWriting(ItemStack stack) {
        return stack.getOrCreateTagElement("modularrouters");
    }

    public static boolean isBlacklist(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ModuleItem.ModuleFlags.BLACKLIST);
    }

    public static boolean ignoreDamage(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ModuleItem.ModuleFlags.IGNORE_DAMAGE);
    }

    public static boolean ignoreNBT(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ModuleItem.ModuleFlags.IGNORE_NBT);
    }

    public static boolean ignoreTags(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ModuleItem.ModuleFlags.IGNORE_TAGS);
    }

    public static boolean checkFlag(ItemStack stack, ModuleItem.ModuleFlags flag) {
        CompoundTag tag = ModuleHelper.validateNBT(stack);
        return tag.contains(flag.getName(), 1) ? tag.getBoolean(flag.getName()) : flag.getDefaultValue();
    }

    public static ModuleItem.Termination getTermination(ItemStack stack) {
        CompoundTag compound = ModuleHelper.validateNBT(stack);
        try {
            return compound.contains(NBT_TERMINATION, 8) ? ModuleItem.Termination.valueOf(compound.getString(NBT_TERMINATION)) : ModuleItem.Termination.NONE;
        }
        catch (IllegalArgumentException e) {
            return ModuleItem.Termination.NONE;
        }
    }

    public static ModuleItem.RelativeDirection getRelativeDirection(ItemStack stack) {
        ModuleItem m;
        Item item = stack.getItem();
        if (item instanceof ModuleItem && (m = (ModuleItem)item).isDirectional()) {
            CompoundTag compound = ModuleHelper.validateNBT(stack);
            try {
                String dirStr = compound.getString(NBT_DIRECTION);
                return dirStr.isEmpty() ? ModuleItem.RelativeDirection.NONE : ModuleItem.RelativeDirection.valueOf(dirStr);
            }
            catch (IllegalArgumentException e) {
                return ModuleItem.RelativeDirection.NONE;
            }
        }
        return ModuleItem.RelativeDirection.NONE;
    }

    public static int getRegulatorAmount(ItemStack itemstack) {
        return ModuleHelper.validateNBT(itemstack).getInt(NBT_REGULATOR_AMOUNT);
    }

    public static RouterRedstoneBehaviour getRedstoneBehaviour(ItemStack stack) {
        AugmentItem.AugmentCounter counter = new AugmentItem.AugmentCounter(stack);
        if (counter.getAugmentCount((Item)ModItems.REDSTONE_AUGMENT.get()) > 0) {
            CompoundTag compound = ModuleHelper.validateNBT(stack);
            try {
                return RouterRedstoneBehaviour.values()[compound.getByte(NBT_REDSTONE_MODE)];
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                return RouterRedstoneBehaviour.ALWAYS;
            }
        }
        return RouterRedstoneBehaviour.ALWAYS;
    }

    public static int getRangeModifier(ItemStack stack) {
        AugmentItem.AugmentCounter counter = new AugmentItem.AugmentCounter(stack);
        return counter.getAugmentCount((Item)ModItems.RANGE_UP_AUGMENT.get()) - counter.getAugmentCount((Item)ModItems.RANGE_DOWN_AUGMENT.get());
    }

    public static boolean isMatchAll(ItemStack stack) {
        return ModuleHelper.validateNBT(stack).getBoolean(NBT_MATCH_ALL);
    }

    public static void setRoundRobinCounter(ItemStack moduleStack, int counter) {
        CompoundTag tag = ModuleHelper.validateNBTForWriting(moduleStack);
        tag.putInt(NBT_RR_COUNTER, counter);
    }

    public static int getRoundRobinCounter(ItemStack moduleStack) {
        return ModuleHelper.validateNBT(moduleStack).getInt(NBT_RR_COUNTER);
    }
}

