/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.desht.modularrouters.logic.filter.Filter;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class SetofItemStack
extends ObjectOpenCustomHashSet<ItemStack> {
    private static final Comparator<? super ItemStack> COMPARE_STACKS = Comparator.comparing(stack -> SetofItemStack.namespace(stack.getItem())).thenComparing(stack -> stack.getHoverName().getString());

    public SetofItemStack(Filter.Flags filterFlags) {
        super((Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public SetofItemStack(Collection<? extends ItemStack> collection, Filter.Flags filterFlags) {
        super(collection, (Hash.Strategy)new ItemStackHashingStrategy(filterFlags));
    }

    public static SetofItemStack fromItemHandler(IItemHandler handler, Filter.Flags filterFlags) {
        NonNullList itemStacks = NonNullList.create();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            itemStacks.add((Object)stack.copy());
        }
        return new SetofItemStack((Collection<? extends ItemStack>)itemStacks, filterFlags);
    }

    public List<ItemStack> sortedList() {
        return this.stream().sorted(COMPARE_STACKS).toList();
    }

    private static String namespace(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getNamespace();
    }

    private record ItemStackHashingStrategy(Filter.Flags filterFlags) implements Hash.Strategy<ItemStack>
    {
        public int hashCode(ItemStack object) {
            int hashCode = Item.getId((Item)object.getItem());
            if (!this.filterFlags.isIgnoreDamage()) {
                hashCode += 37 * object.getDamageValue();
            }
            if (!this.filterFlags.isIgnoreNBT() && object.hasTag()) {
                hashCode += 37 * object.getTag().hashCode();
            }
            return hashCode;
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getItem() == o2.getItem() && (this.filterFlags.isIgnoreDamage() || o1.getDamageValue() == o2.getDamageValue()) && (this.filterFlags.isIgnoreNBT() || !o1.hasTag() || o1.getTag().equals((Object)o2.getTag()));
        }
    }
}

