/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util.fake_player;

import com.mojang.authlib.GameProfile;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class RouterFakePlayer
extends FakePlayer {
    private final ModularRouterBlockEntity router;
    private ItemStack prevHeldStack = ItemStack.EMPTY;

    public RouterFakePlayer(ModularRouterBlockEntity router, ServerLevel level, GameProfile profile) {
        super(level, profile);
        this.router = router;
    }

    public Vec3 position() {
        return new Vec3(this.getX(), this.getY(), this.getZ());
    }

    public boolean isSilent() {
        return true;
    }

    public double getEyeY() {
        return this.getY();
    }

    public void tick() {
        ++this.attackStrengthTicker;
        if (this.router.caresAboutItemAttributes() && !ItemStack.matches((ItemStack)this.prevHeldStack, (ItemStack)this.getMainHandItem())) {
            this.getAttributes().removeAttributeModifiers(this.prevHeldStack.getAttributeModifiers(EquipmentSlot.MAINHAND));
            this.getAttributes().addTransientAttributeModifiers(this.getMainHandItem().getAttributeModifiers(EquipmentSlot.MAINHAND));
            this.prevHeldStack = this.getMainHandItem().copy();
        }
    }

    public void giveExperiencePoints(int amount) {
        Vec3 pos = Vec3.atCenterOf((Vec3i)this.router.getBlockPos().above());
        ExperienceOrb orb = new ExperienceOrb(this.router.nonNullLevel(), pos.x, pos.y, pos.z, amount);
        this.router.nonNullLevel().addFreshEntity((Entity)orb);
    }
}

