/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.friendlyfire.Config;
import net.darkhax.friendlyfire.Constants;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class FriendlyFireCommon {
    private static final TagKey<Item> BYPASS_PET = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("friendlyfire", "bypass_pet"));
    private static final TagKey<Item> BYPASS_ALL = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("friendlyfire", "bypass_all_protection"));
    private static final TagKey<EntityType<?>> GENERAL_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation("friendlyfire", "general_protection"));
    private static final TagKey<EntityType<?>> PLAYER_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation("friendlyfire", "player_protection"));
    private static final TagKey<EntityType<?>> BYPASSED_PROTECTION = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation("friendlyfire", "bypassed_entity_types"));
    private static final Config CONFIG = Config.load(new File(Services.PLATFORM.getConfigDirectory(), "friendlyfire.json"));

    public static void init() {
        Constants.LOG.debug("Protect children = {}", (Object)FriendlyFireCommon.CONFIG.protectChildren);
        Constants.LOG.debug("Protect pets from owner = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromOwner);
        Constants.LOG.debug("Protect pets from pets = {}", (Object)FriendlyFireCommon.CONFIG.protectPetsFromPets);
        Constants.LOG.debug("Reflect damage = {}", (Object)FriendlyFireCommon.CONFIG.reflectDamage);
    }

    public static boolean preventAttack(Entity target, DamageSource source, float amount) {
        boolean preventDamage;
        Entity attacker = source.getEntity();
        boolean bl = preventDamage = source != null && FriendlyFireCommon.isProtected(target, attacker, amount);
        if (preventDamage && attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            if (FriendlyFireCommon.CONFIG.displayHitWarning) {
                player.displayClientMessage((Component)Component.translatable((String)"notif.friendlyfire.protected", (Object[])new Object[]{target.getName()}), true);
            }
        }
        return preventDamage;
    }

    private static boolean isProtected(Entity victim, Entity attacker, float amount) {
        AgeableMob agable;
        UUID ownerId;
        ItemStack heldItem;
        if (victim.getType().is(BYPASSED_PROTECTION)) {
            return false;
        }
        if (victim == null || attacker == null || attacker.isCrouching()) {
            return false;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            v0 = attackerLiving.getMainHandItem();
        } else {
            v0 = heldItem = ItemStack.EMPTY;
        }
        if (heldItem.is(BYPASS_ALL)) {
            return false;
        }
        if (victim.getType().is(GENERAL_PROTECTION)) {
            return true;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (victim.getType().is(PLAYER_PROTECTION)) {
                return true;
            }
        }
        if ((ownerId = FriendlyFireCommon.getOwner(victim)) != null && !heldItem.is(BYPASS_PET)) {
            if (FriendlyFireCommon.CONFIG.protectPetsFromOwner && ownerId.equals(attacker.getUUID())) {
                if (FriendlyFireCommon.CONFIG.reflectDamage) {
                    attacker.hurt(attacker.level().damageSources().generic(), amount);
                }
                return true;
            }
            if (FriendlyFireCommon.CONFIG.protectPetsFromPets && ownerId.equals(FriendlyFireCommon.getOwner(attacker))) {
                return true;
            }
        }
        if (FriendlyFireCommon.CONFIG.protectTeamMembers && FriendlyFireCommon.isOnProtectedTeam(attacker, victim)) {
            return true;
        }
        return FriendlyFireCommon.CONFIG.protectChildren && attacker instanceof Player && !(victim instanceof Enemy) && victim instanceof AgeableMob && (agable = (AgeableMob)victim).isBaby() && !attacker.isCrouching();
    }

    private static boolean isOnProtectedTeam(Entity attacker, Entity victim) {
        PlayerTeam attackerTeam = FriendlyFireCommon.getEffectiveTeam(attacker);
        PlayerTeam victimTeam = FriendlyFireCommon.getEffectiveTeam(victim);
        return attackerTeam != null && victimTeam != null && attackerTeam.isAlliedTo((Team)victimTeam) && victimTeam.isAlliedTo((Team)attackerTeam) && (!FriendlyFireCommon.CONFIG.respectTeamRules || !victimTeam.isAllowFriendlyFire());
    }

    @Nullable
    private static PlayerTeam getEffectiveTeam(Entity entity) {
        OwnableEntity ownable;
        PlayerTeam directTeam = entity.getTeam();
        if (directTeam == null && entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwnerUUID() != null) {
            ServerLevel server;
            GameProfile fetchResult;
            if (ownable.getOwner() != null) {
                return ownable.getOwner().getTeam();
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (fetchResult = (GameProfile)(server = (ServerLevel)level).getServer().getProfileCache().get(ownable.getOwnerUUID()).orElse(null)) != null) {
                return entity.level().getScoreboard().getPlayersTeam(fetchResult.getName());
            }
        }
        return directTeam;
    }

    @Nullable
    private static UUID getOwner(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            return ownable.getOwnerUUID();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.getOwnerUUID();
        }
        return null;
    }
}

