/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import net.darkhax.friendlyfire.FriendlyFireCommon;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;

@Mod(value="friendlyfire")
public class FriendlyFireNeoForge {
    public FriendlyFireNeoForge() {
        FriendlyFireCommon.init();
        NeoForge.EVENT_BUS.addListener(FriendlyFireNeoForge::onEntityAttack);
        NeoForge.EVENT_BUS.addListener(FriendlyFireNeoForge::onEntityHurt);
    }

    private static void onEntityAttack(LivingAttackEvent event) {
        if (FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getAmount())) {
            event.setCanceled(true);
            event.getEntity().setLastHurtByMob(null);
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.setLastHurtByMob(null);
            }
        }
    }

    private static void onEntityHurt(LivingHurtEvent event) {
        if (FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getAmount())) {
            event.setCanceled(true);
            event.setAmount(0.0f);
            event.getEntity().setLastHurtByMob(null);
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.setLastHurtByMob(null);
            }
        }
    }
}

