/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau;

import fuzs.combatnouveau.config.ClientConfig;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.handler.AttackAttributeHandler;
import fuzs.combatnouveau.handler.ClassicCombatHandler;
import fuzs.combatnouveau.handler.CombatTestHandler;
import fuzs.combatnouveau.network.client.ServerboundSweepAttackMessage;
import fuzs.combatnouveau.network.client.ServerboundSwingArmMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.event.v1.entity.ProjectileImpactCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ItemAttributeModifiersCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.network.v3.NetworkHandlerV3;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombatNouveau
implements ModConstructor {
    public static final String MOD_ID = "combatnouveau";
    public static final String MOD_NAME = "Combat Nouveau";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Combat Nouveau");
    public static final NetworkHandlerV3 NETWORK = NetworkHandlerV3.builder((String)"combatnouveau").registerServerbound(ServerboundSweepAttackMessage.class).registerServerbound(ServerboundSwingArmMessage.class);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"combatnouveau").client(ClientConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        CombatNouveau.registerHandlers();
    }

    private static void registerHandlers() {
        ItemAttributeModifiersCallback.EVENT.register(AttackAttributeHandler::onItemAttributeModifiers);
        LivingKnockBackCallback.EVENT.register(ClassicCombatHandler::onLivingKnockBack);
        ProjectileImpactCallback.EVENT.register(ClassicCombatHandler::onProjectileImpact);
        PlayerInteractEvents.USE_ITEM.register(CombatTestHandler::onUseItem);
        UseItemEvents.START.register(CombatTestHandler::onUseItemStart);
        PlayerTickEvents.START.register(CombatTestHandler::onStartPlayerTick);
        LivingHurtCallback.EVENT.register(CombatTestHandler::onLivingHurt);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

