/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.client.handler;

import com.google.common.collect.Multimap;
import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.client.helper.AttributeTooltipHelper;
import fuzs.combatnouveau.config.ClientConfig;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.core.CommonAbstractions;
import fuzs.combatnouveau.handler.AttackAttributeHandler;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class AttributesTooltipHandler {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public static void onItemTooltip(ItemStack stack, @Nullable Player player, List<Component> lines, TooltipFlag context) {
        Item item;
        if (!CombatNouveau.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            return;
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).additionalAttackReach && AttackAttributeHandler.ATTACK_RANGE_BONUS_OVERRIDES.keySet().stream().anyMatch(t -> t.isInstance(stack.getItem())) || ((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).attackReachOverrides.contains((Object)stack.getItem())) {
            AttributesTooltipHandler.convertToDefaultAttribute(lines, AttackAttributeHandler.BASE_ATTACK_REACH_UUID, stack, player);
        }
        if (((ClientConfig)CombatNouveau.CONFIG.get(ClientConfig.class)).specialArmorAttributes && (item = stack.getItem()) instanceof ArmorItem) {
            ArmorItem item2 = (ArmorItem)item;
            AttributesTooltipHandler.convertToDefaultAttribute(lines, ARMOR_MODIFIER_UUID_PER_SLOT[item2.getType().getSlot().getIndex()], stack, player);
        }
    }

    private static void convertToDefaultAttribute(List<Component> lines, UUID attributeId, ItemStack stack, @Nullable Player player) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributesBySlot = AttributeTooltipHelper.getAttributesBySlot(stack);
        for (Map.Entry<EquipmentSlot, Multimap<Attribute, AttributeModifier>> slotToAttributeMap : attributesBySlot.entrySet()) {
            ArrayList attributeModifiers = Lists.newArrayList();
            for (Map.Entry attributeToModifier : slotToAttributeMap.getValue().entries()) {
                if (!((AttributeModifier)attributeToModifier.getValue()).getId().equals(attributeId)) continue;
                attributeModifiers.add(attributeToModifier);
            }
            block2: for (Map.Entry entry : attributeModifiers) {
                AttributeModifier attributeModifier;
                Attribute attribute = (Attribute)entry.getKey();
                double attributeAmount = AttributesTooltipHandler.getAdjustedAttributeAmount(stack, player, attribute, attributeModifier = (AttributeModifier)entry.getValue());
                if (attributeAmount == 0.0) continue;
                int slotModifiersStart = -1;
                for (int i = 0; i < lines.size(); ++i) {
                    TranslatableContents translatableComponent;
                    Component component = lines.get(i);
                    if (AttributeTooltipHelper.matchesAttributeComponent(component, attribute, attributeModifier)) {
                        lines.set(i, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)("attribute.modifier.equals." + attributeModifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(attributeAmount), Component.translatable((String)attribute.getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
                        continue block2;
                    }
                    ComponentContents componentContents = component.getContents();
                    if (!(componentContents instanceof TranslatableContents) || !(translatableComponent = (TranslatableContents)componentContents).getKey().equals("item.modifiers." + slotToAttributeMap.getKey().getName())) continue;
                    slotModifiersStart = i + 1;
                }
                if (slotModifiersStart == -1) continue;
                lines.add(slotModifiersStart, (Component)Component.literal((String)" ").append((Component)Component.translatable((String)("attribute.modifier.equals." + attributeModifier.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(attributeAmount), Component.translatable((String)attribute.getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
            }
        }
    }

    public static double getAdjustedAttributeAmount(ItemStack stack, @Nullable Player player, Attribute attribute, AttributeModifier attributeModifier) {
        double attributeAmount = attributeModifier.getAmount();
        if (player != null) {
            attributeAmount += player.getAttributes().hasAttribute(attribute) ? player.getAttributeBaseValue(attribute) : 0.0;
        }
        if (attribute == Attributes.ATTACK_DAMAGE) {
            attributeAmount += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)MobType.UNDEFINED);
        }
        if (attribute == CommonAbstractions.INSTANCE.getAttackRangeAttribute() && !ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            attributeAmount += 3.0;
        }
        if (attributeModifier.getOperation() == AttributeModifier.Operation.ADDITION) {
            RangedAttribute rangedAttribute;
            if (attribute instanceof RangedAttribute && (rangedAttribute = (RangedAttribute)attribute).getMaxValue() < 10.0) {
                attributeAmount *= 10.0 / rangedAttribute.getMaxValue();
            }
        } else {
            attributeAmount *= 100.0;
        }
        return attributeAmount;
    }
}

