/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.client.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class AttributeTooltipHelper {
    private AttributeTooltipHelper() {
    }

    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getAttributesBySlot(ItemStack stack) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            Multimap multimap = stack.getAttributeModifiers(equipmentSlot);
            if (multimap.isEmpty()) continue;
            map.put(equipmentSlot, multimap);
        }
        return map;
    }

    public static boolean matchesAttributeComponent(Component component, Attribute attribute, @Nullable AttributeModifier attributeModifier) {
        MutableComponent mutableComponent;
        TranslatableContents translatableContents = null;
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents1;
            translatableContents = translatableContents1 = (TranslatableContents)componentContents;
        } else if (component instanceof MutableComponent && !(mutableComponent = (MutableComponent)component).getSiblings().isEmpty() && (componentContents = ((Component)mutableComponent.getSiblings().get(0)).getContents()) instanceof TranslatableContents) {
            TranslatableContents translatableContents1;
            translatableContents = translatableContents1 = (TranslatableContents)componentContents;
        }
        if (translatableContents != null) {
            Component component1;
            Object object;
            double scaledAmount = 0.0;
            String translationKey = null;
            if (attributeModifier != null) {
                scaledAmount = AttributeTooltipHelper.getScaledAttributeAmount(attribute, attributeModifier);
                if (attributeModifier.getAmount() > 0.0) {
                    translationKey = "attribute.modifier.plus." + attributeModifier.getOperation().toValue();
                } else if (attributeModifier.getAmount() < 0.0) {
                    scaledAmount *= -1.0;
                    translationKey = "attribute.modifier.take." + attributeModifier.getOperation().toValue();
                }
            }
            Object[] args = translatableContents.getArgs();
            if ((attributeModifier == null || translationKey != null && translatableContents.getKey().equals(translationKey)) && args.length >= 2 && (attributeModifier == null || args[0].equals(ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(scaledAmount))) && (object = args[1]) instanceof Component && (object = (component1 = (Component)object).getContents()) instanceof TranslatableContents) {
                TranslatableContents translatableComponent1 = (TranslatableContents)object;
                return translatableComponent1.getKey().equals(attribute.getDescriptionId());
            }
        }
        return false;
    }

    private static double getScaledAttributeAmount(Attribute attribute, AttributeModifier attributeModifier) {
        double attributeAmount = attributeModifier.getAmount();
        if (attributeModifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL) {
            if (attribute.equals(Attributes.KNOCKBACK_RESISTANCE)) {
                return attributeAmount * 10.0;
            }
            return attributeAmount;
        }
        return attributeAmount * 100.0;
    }

    public static int removeAllAttributes(List<Component> lines) {
        int endIndex;
        int startIndex = AttributeTooltipHelper.findAttributesStart(lines);
        if (startIndex >= 0 && startIndex < (endIndex = AttributeTooltipHelper.findAttributesEnd(lines))) {
            for (int i = 0; i < endIndex - startIndex + 1; ++i) {
                lines.remove(startIndex);
            }
            return startIndex;
        }
        return -1;
    }

    public static int findAttributesStart(List<Component> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            TranslatableContents contents;
            ComponentContents componentContents = lines.get(i).getContents();
            if (!(componentContents instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().startsWith("item.modifiers.")) continue;
            if (--i >= 0 && lines.get(i).getContents() == PlainTextContents.EMPTY) {
                return i;
            }
            return ++i;
        }
        return -1;
    }

    public static int findAttributesEnd(List<Component> lines) {
        int index = -1;
        for (int i = 0; i < lines.size(); ++i) {
            Component component = lines.get(i);
            TranslatableContents translatableComponent = null;
            ComponentContents componentContents = component.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatableComponent1;
                translatableComponent = translatableComponent1 = (TranslatableContents)componentContents;
            } else {
                ComponentContents componentContents2;
                PlainTextContents.LiteralContents textComponent;
                componentContents = component.getContents();
                if (componentContents instanceof PlainTextContents.LiteralContents && (textComponent = (PlainTextContents.LiteralContents)componentContents).text().equals(" ") && !component.getSiblings().isEmpty() && (componentContents2 = ((Component)component.getSiblings().get(0)).getContents()) instanceof TranslatableContents) {
                    TranslatableContents translatableComponent1;
                    translatableComponent = translatableComponent1 = (TranslatableContents)componentContents2;
                }
            }
            if (translatableComponent == null || !translatableComponent.getKey().startsWith("attribute.modifier.")) continue;
            index = i;
        }
        return index;
    }

    public static double calculateAttributeValue(@Nullable Player player, Attribute attribute, Collection<AttributeModifier> modifiers) {
        double baseValue = player != null && player.getAttributes().hasAttribute(attribute) ? player.getAttributeBaseValue(attribute) : 0.0;
        Map<AttributeModifier.Operation, List<AttributeModifier>> modifiersByOperation = modifiers.stream().collect(Collectors.groupingBy(AttributeModifier::getOperation));
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.ADDITION, List.of())) {
            baseValue += attributeModifier.getAmount();
        }
        double multipliedValue = baseValue;
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.MULTIPLY_BASE, List.of())) {
            multipliedValue += baseValue * attributeModifier.getAmount();
        }
        for (AttributeModifier attributeModifier : modifiersByOperation.getOrDefault(AttributeModifier.Operation.MULTIPLY_TOTAL, List.of())) {
            multipliedValue *= 1.0 + attributeModifier.getAmount();
        }
        return attribute.sanitizeValue(multipliedValue);
    }
}

