/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.handler;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClassicCombatHandler {
    public static EventResult onProjectileImpact(Projectile projectile, HitResult hitResult) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).weakAttacksKnockBackPlayers) {
            return EventResult.PASS;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY && projectile.getOwner() == null) {
            projectile.setOwner((Entity)projectile);
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingKnockBack(LivingEntity entity, DefaultedDouble strength, DefaultedDouble ratioX, DefaultedDouble ratioZ) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).upwardsKnockback) {
            return EventResult.PASS;
        }
        if (!entity.onGround() && !entity.isInWater()) {
            strength.mapDouble(s -> s * (1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)));
            Vec3 deltaMovement = entity.getDeltaMovement();
            entity.setDeltaMovement(deltaMovement.x, Math.min(0.4, deltaMovement.y / 2.0 + strength.getAsDouble()), deltaMovement.x);
        }
        return EventResult.PASS;
    }
}

