/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.helper;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.core.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.ToolTypeHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class SweepAttackHelper {
    public static void tryAttackAir(Player player) {
        if (player.getAttackStrengthScale(0.5f) >= 1.0f) {
            double walkDist = player.walkDist - player.walkDistO;
            if (!player.onGround() || !(walkDist < (double)player.getSpeed())) {
                return;
            }
            float attackDamage = (float)player.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            if (attackDamage > 0.0f && player.getAttackStrengthScale(0.5f) > 0.9f && SweepAttackHelper.canPerformSweepAttack(player)) {
                double attackReach = SweepAttackHelper.getCurrentAttackReach(player, player.isCreative());
                double moveX = (double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)))) * 2.0;
                double moveZ = (double)Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * 2.0;
                AABB aABB = CommonAbstractions.INSTANCE.getSweepHitBox(player, (Entity)player).move(moveX, 0.0, moveZ);
                SweepAttackHelper.performSweepAttack(player, aABB, attackReach, attackDamage, null);
            }
            player.swing(InteractionHand.MAIN_HAND);
        }
    }

    private static boolean canPerformSweepAttack(Player player) {
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).noSweepingWhenSneaking && player.isShiftKeyDown()) {
            return false;
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).requireSweepingEdge) {
            return EnchantmentHelper.getSweepingDamageRatio((LivingEntity)player) > 0.0f;
        }
        ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        return ToolTypeHelper.INSTANCE.isSword(itemInHand);
    }

    private static double getCurrentAttackReach(Player player, boolean hasFarPickRange) {
        double attackReach;
        Attribute attackRangeAttribute = CommonAbstractions.INSTANCE.getAttackRangeAttribute();
        double d = attackReach = player.getAttributes().hasAttribute(attackRangeAttribute) ? player.getAttribute(attackRangeAttribute).getValue() : 0.0;
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isForgeLike()) {
            attackReach += 3.0;
        }
        if (hasFarPickRange) {
            attackReach += 0.5;
        }
        return attackReach;
    }

    private static void performSweepAttack(Player player, AABB aABB, double currentAttackReach, float baseAttackDamage, @Nullable Entity target) {
        float h = 1.0f + EnchantmentHelper.getSweepingDamageRatio((LivingEntity)player) * baseAttackDamage;
        List list = player.level().getEntitiesOfClass(LivingEntity.class, aABB);
        for (LivingEntity livingEntity : list) {
            if (livingEntity == player || livingEntity == target || player.isAlliedTo((Entity)livingEntity) || livingEntity instanceof ArmorStand && ((ArmorStand)livingEntity).isMarker()) continue;
            double d = currentAttackReach + (double)livingEntity.getBbWidth() * 0.5;
            if (!(player.distanceToSqr((Entity)livingEntity) < d * d)) continue;
            livingEntity.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
            livingEntity.hurt(player.damageSources().playerAttack(player), h);
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
        if (player.level() instanceof ServerLevel) {
            double d = -Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            double i = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX() + d, player.getY() + (double)player.getBbHeight() * 0.5, player.getZ() + i, 0, d, 0.0, i, 0.0);
        }
    }
}

