/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.mixin;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ServerConfig;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
abstract class FoodDataMixin {
    @Shadow
    private int foodLevel = 20;
    @Shadow
    private float saturationLevel;
    @Shadow
    private float exhaustionLevel;
    @Shadow
    private int tickTimer;
    @Shadow
    private int lastFoodLevel = 20;

    FoodDataMixin() {
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(Player player, CallbackInfo callback) {
        boolean flag;
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).balancedFoodMechanics) {
            return;
        }
        Difficulty difficulty = player.level().getDifficulty();
        this.lastFoodLevel = this.foodLevel;
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((flag = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.foodLevel > 6 && player.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= 40) {
                player.heal(1.0f);
                if (player.getRandom().nextBoolean()) {
                    this.foodLevel = Math.max(this.foodLevel - 1, 0);
                }
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= 40) {
                if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.hurt(player.damageSources().starve(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
        callback.cancel();
    }
}

