/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.mixin.client;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.config.ClientConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getAttackAnim"}, at={@At(value="TAIL")}, cancellable=true)
    public void getAttackAnim(float tickDelta, CallbackInfoReturnable<Float> callback) {
        if (!((ClientConfig)CombatNouveau.CONFIG.get(ClientConfig.class)).alternativeSwingAnimation) {
            return;
        }
        float swingProgress = callback.getReturnValueF();
        if (swingProgress > 0.4f && swingProgress < 0.95f) {
            callback.setReturnValue((Object)Float.valueOf(0.4f + 0.6f * (float)Math.pow((swingProgress - 0.4f) / 0.6f, 4.0)));
        }
    }
}

