/*
 * Decompiled with CFR 0.152.
 */
package fuzs.combatnouveau.mixin.client;

import fuzs.combatnouveau.CombatNouveau;
import fuzs.combatnouveau.client.handler.AutoAttackHandler;
import fuzs.combatnouveau.config.ServerConfig;
import fuzs.combatnouveau.mixin.client.accessor.MultiPlayerGameModeAccessor;
import fuzs.combatnouveau.network.client.ServerboundSweepAttackMessage;
import fuzs.combatnouveau.network.client.ServerboundSwingArmMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
abstract class MinecraftMixin {
    @Shadow
    public ClientLevel level;
    @Shadow
    public LocalPlayer player;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;

    MinecraftMixin() {
    }

    @Inject(method={"continueAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;stopDestroyBlock()V", shift=At.Shift.AFTER)})
    private void continueAttack(boolean attacking, CallbackInfo callback) {
        if (!((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).holdAttackButton) {
            return;
        }
        if (attacking && !this.player.isUsingItem() && (double)this.player.getAttackStrengthScale(0.5f) >= 1.0 && AutoAttackHandler.readyForAutoAttack()) {
            this.startAttack();
            AutoAttackHandler.resetAutoAttackDelay();
        }
    }

    @Shadow
    private boolean startAttack() {
        throw new RuntimeException();
    }

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void startAttack(CallbackInfoReturnable<Boolean> callback) {
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).retainEnergyOnMiss) {
            this.player.swing(InteractionHand.MAIN_HAND, false);
            CombatNouveau.NETWORK.sendToServer((Record)new ServerboundSwingArmMessage(InteractionHand.MAIN_HAND));
            callback.setReturnValue((Object)false);
        }
        if (((ServerConfig)CombatNouveau.CONFIG.get(ServerConfig.class)).airSweepAttack && this.player.getAttackStrengthScale(0.5f) >= 1.0f) {
            ((MultiPlayerGameModeAccessor)this.gameMode).combatnouveau$callEnsureHasSentCarriedItem();
            CombatNouveau.NETWORK.sendToServer((Record)new ServerboundSweepAttackMessage(this.player.isShiftKeyDown()));
        }
    }
}

