/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class PatternDetailsTooltip {
    public static final Component OUTPUT_TEXT_CRAFTS = GuiText.Crafts.text();
    public static final Component OUTPUT_TEXT_PRODUCES = GuiText.Produces.text();
    private Component outputMethod;
    private final List<Property> additionalProperties = new ArrayList<Property>();
    private final List<Entry> inputs = new ArrayList<Entry>();
    private final List<Entry> outputs = new ArrayList<Entry>();

    public PatternDetailsTooltip(Component outputMethod) {
        this.setOutputMethod(outputMethod);
    }

    public void setOutputMethod(Component outputMethod) {
        this.outputMethod = Objects.requireNonNull(outputMethod, "outputMethod");
    }

    public List<Property> getProperties() {
        return this.additionalProperties;
    }

    public List<Entry> getInputs() {
        return this.inputs;
    }

    public List<Entry> getOutputs() {
        return this.outputs;
    }

    public void addInput(Entry entry) {
        this.inputs.add(entry);
    }

    public void addInput(AEKey what, long amount) {
        this.inputs.add(new ValidEntry(what, amount));
    }

    public void addInvalidInput(Component description) {
        this.inputs.add(new InvalidEntry(description, null, 0L));
    }

    public void addInvalidInput(Component description, long amount) {
        this.inputs.add(new InvalidEntry(description, null, amount));
    }

    public void addInvalidInput(Component description, AEKeyType type, long amount) {
        this.inputs.add(new InvalidEntry(description, type, amount));
    }

    public void addOutput(AEKey what, long amount) {
        this.outputs.add(new ValidEntry(what, amount));
    }

    public void addOutput(Entry entry) {
        this.outputs.add(entry);
    }

    public void addInvalidOutput(Component description) {
        this.outputs.add(new InvalidEntry(description, null, 0L));
    }

    public void addInvalidOutput(Component description, long amount) {
        this.outputs.add(new InvalidEntry(description, null, amount));
    }

    public void addInvalidOutput(Component description, AEKeyType type, long amount) {
        this.outputs.add(new InvalidEntry(description, type, amount));
    }

    public void addProperty(Component name, Component value) {
        this.additionalProperties.add(new Property(name, value));
    }

    public void addProperty(Component description) {
        this.additionalProperties.add(new Property(description, null));
    }

    public void addInputsAndOutputs(IPatternDetails details) {
        for (IPatternDetails.IInput input : details.getInputs()) {
            if (input == null) continue;
            this.addInput(input.getPossibleInputs()[0].what(), input.getPossibleInputs()[0].amount() * input.getMultiplier());
        }
        for (GenericStack output : details.getOutputs()) {
            if (output == null) continue;
            this.addOutput(output.what(), output.amount());
        }
    }

    public Component getOutputMethod() {
        return this.outputMethod;
    }

    public record ValidEntry(AEKey what, long amount) implements Entry
    {
        public ValidEntry(GenericStack stack) {
            this(stack.what(), stack.amount());
        }
    }

    public record InvalidEntry(Component name, @Nullable AEKeyType type, long amount) implements Entry
    {
    }

    public record Property(Component name, @Nullable Component value) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Entry {
    }
}

