/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AEItemKey
extends AEKey {
    private static final Logger LOG = LoggerFactory.getLogger(AEItemKey.class);
    private final Item item;
    private final InternedTag internedTag;
    private final InternedTag internedCaps;
    private final int hashCode;
    private final int cachedDamage;
    @Nullable
    private ItemStack readOnlyStack;
    private int maxStackSize = -1;

    @Nullable
    private static CompoundTag serializeStackCaps(ItemStack stack) {
        try {
            CompoundTag caps = stack.serializeAttachments();
            return caps == null || caps.isEmpty() ? null : caps;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to call serializeCaps", ex);
        }
    }

    private AEItemKey(Item item, InternedTag internedTag, InternedTag internedCaps) {
        Tag tag;
        this.item = item;
        this.internedTag = internedTag;
        this.internedCaps = internedCaps;
        this.hashCode = Objects.hash(item, internedTag, internedCaps);
        if (internedTag.tag != null && (tag = internedTag.tag.get("Damage")) instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            this.cachedDamage = numericTag.getAsInt();
        } else {
            this.cachedDamage = 0;
        }
    }

    @Nullable
    public static AEItemKey of(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        AEItemKey ret = AEItemKey.of((ItemLike)stack.getItem(), stack.getTag(), AEItemKey.serializeStackCaps(stack));
        ret.maxStackSize = stack.getMaxStackSize();
        return ret;
    }

    public static boolean matches(AEKey what, ItemStack itemStack) {
        AEItemKey itemKey;
        return what instanceof AEItemKey && (itemKey = (AEItemKey)what).matches(itemStack);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEItemKey;
    }

    public static AEKeyFilter filter() {
        return AEItemKey::is;
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.items();
    }

    @Override
    public AEItemKey dropSecondary() {
        return AEItemKey.of((ItemLike)this.item, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEItemKey aeItemKey = (AEItemKey)o;
        return this.item == aeItemKey.item && this.internedTag == aeItemKey.internedTag && this.internedCaps == aeItemKey.internedCaps;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEItemKey of(ItemLike item) {
        return AEItemKey.of(item, null);
    }

    public static AEItemKey of(ItemLike item, @Nullable CompoundTag tag) {
        return AEItemKey.of(item, tag, null);
    }

    private static AEItemKey of(ItemLike item, @Nullable CompoundTag tag, @Nullable CompoundTag caps) {
        return new AEItemKey(item.asItem(), InternedTag.of(tag, false), InternedTag.of(caps, false));
    }

    public boolean matches(ItemStack stack) {
        return !stack.isEmpty() && stack.is(this.item) && Objects.equals(stack.getTag(), this.internedTag.tag) && Objects.equals(AEItemKey.serializeStackCaps(stack), this.internedCaps.tag);
    }

    public boolean matches(Ingredient ingredient) {
        return ingredient.test(this.getReadOnlyStack());
    }

    public ItemStack getReadOnlyStack() {
        if (this.readOnlyStack == null) {
            this.readOnlyStack = new ItemStack((ItemLike)this.item, 1, this.internedCaps.tag);
            this.readOnlyStack.setTag(this.internedTag.tag);
        } else if (this.readOnlyStack.isEmpty()) {
            LOG.error("Something destroyed the read-only itemstack of {}", (Object)this);
            this.readOnlyStack = null;
            return this.getReadOnlyStack();
        }
        return this.readOnlyStack;
    }

    public ItemStack toStack() {
        return this.toStack(1);
    }

    public ItemStack toStack(int count) {
        if (count <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack result = new ItemStack((ItemLike)this.item, count, this.internedCaps.tag);
        result.setTag(this.copyTag());
        return result;
    }

    public Item getItem() {
        return this.item;
    }

    @Nullable
    public static AEItemKey fromTag(CompoundTag tag) {
        try {
            CompoundTag extraCaps;
            Item item = (Item)BuiltInRegistries.ITEM.getOptional(new ResourceLocation(tag.getString("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown item id."));
            CompoundTag extraTag = tag.contains("tag") ? tag.getCompound("tag") : null;
            CompoundTag compoundTag = extraCaps = tag.contains("caps") ? tag.getCompound("caps") : null;
            if (extraCaps != null) {
                ItemStack stack = new ItemStack((ItemLike)item, 1, extraCaps);
                CompoundTag sanitizedCaps = stack.serializeAttachments();
                if (!Objects.equals(extraCaps, sanitizedCaps)) {
                    LOG.info("Sanitized item attachments for {} from {} -> {}", new Object[]{item.asItem(), extraCaps, sanitizedCaps});
                }
                extraCaps = sanitizedCaps;
            }
            return AEItemKey.of((ItemLike)item, extraTag, extraCaps);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid item key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public CompoundTag toTag() {
        CompoundTag result = new CompoundTag();
        result.putString("id", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
        if (this.internedTag.tag != null) {
            result.put("tag", (Tag)this.internedTag.tag.copy());
        }
        if (this.internedCaps.tag != null) {
            result.put("caps", (Tag)this.internedCaps.tag.copy());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.item;
    }

    @Override
    public int getFuzzySearchValue() {
        return this.cachedDamage;
    }

    @Override
    public int getFuzzySearchMaxValue() {
        return this.getReadOnlyStack().getMaxDamage();
    }

    @Override
    public ResourceLocation getId() {
        return BuiltInRegistries.ITEM.getKey((Object)this.item);
    }

    @Nullable
    public CompoundTag getTag() {
        return this.internedTag.tag;
    }

    @Nullable
    public CompoundTag copyTag() {
        return this.internedTag.tag != null ? this.internedTag.tag.copy() : null;
    }

    public boolean hasTag() {
        return this.internedTag.tag != null;
    }

    @Override
    public ItemStack wrapForDisplayOrFilter() {
        return this.toStack();
    }

    @Override
    public void addDrops(long amount, List<ItemStack> drops, Level level, BlockPos pos) {
        while (amount > 0L) {
            if (drops.size() > 1000) {
                AELog.warn("Tried dropping an excessive amount of items, ignoring %s %ss", amount, this.item);
                break;
            }
            long taken = Math.min(amount, (long)this.getMaxStackSize());
            amount -= taken;
            drops.add(this.toStack((int)taken));
        }
    }

    @Override
    protected Component computeDisplayName() {
        return this.getReadOnlyStack().getHoverName();
    }

    @Override
    public boolean isTagged(TagKey<?> tag) {
        return this.item.builtInRegistryHolder().is(tag);
    }

    public boolean isDamaged() {
        return this.cachedDamage > 0;
    }

    public int getMaxStackSize() {
        int ret = this.maxStackSize;
        if (ret == -1) {
            this.maxStackSize = ret = this.getReadOnlyStack().getMaxStackSize();
        }
        return ret;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf data) {
        data.writeVarInt(Item.getId((Item)this.item));
        CompoundTag compoundTag = null;
        if (this.item.canBeDepleted() || this.item.shouldOverrideMultiplayerNbt()) {
            compoundTag = this.internedTag.tag;
        }
        data.writeNbt((Tag)compoundTag);
        data.writeNbt((Tag)this.internedCaps.tag);
    }

    public static AEItemKey fromPacket(FriendlyByteBuf data) {
        int i = data.readVarInt();
        Item item = Item.byId((int)i);
        CompoundTag compoundTag = data.readNbt();
        CompoundTag attachedCapsData = data.readNbt();
        return new AEItemKey(item, InternedTag.of(compoundTag, true), InternedTag.of(attachedCapsData, true));
    }

    public String toString() {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this.item);
        String idString = id != BuiltInRegistries.ITEM.getDefaultKey() ? id.toString() : this.item.getClass().getName() + "(unregistered)";
        return this.internedTag.tag == null ? idString : idString + " (+tag)";
    }

    private static final class InternedTag {
        private static final InternedTag EMPTY = new InternedTag(null);
        private static final WeakHashMap<InternedTag, WeakReference<InternedTag>> INTERNED = new WeakHashMap();
        private final CompoundTag tag;
        private final int hashCode;

        InternedTag(CompoundTag tag) {
            this.tag = tag;
            this.hashCode = Objects.hashCode(tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedTag internedTag = (InternedTag)o;
            return Objects.equals(this.tag, internedTag.tag);
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InternedTag of(@Nullable CompoundTag tag, boolean giveOwnership) {
            if (tag == null) {
                return EMPTY;
            }
            Class<AEItemKey> clazz = AEItemKey.class;
            synchronized (AEItemKey.class) {
                InternedTag searchHolder = new InternedTag(tag);
                WeakReference<InternedTag> weakRef = INTERNED.get(searchHolder);
                InternedTag ret = null;
                if (weakRef != null) {
                    ret = (InternedTag)weakRef.get();
                }
                if (ret == null) {
                    ret = giveOwnership ? searchHolder : new InternedTag(tag.copy());
                    INTERNED.put(ret, new WeakReference<InternedTag>(ret));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ret;
            }
        }
    }
}

