/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseBlockItem;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.util.InteractionUtil;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CraftingBlockItem
extends AEBaseBlockItem {
    protected final Supplier<ItemLike> disassemblyExtra;

    public CraftingBlockItem(Block id, Item.Properties props, Supplier<ItemLike> disassemblyExtra) {
        super(id, props);
        this.disassemblyExtra = disassemblyExtra;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (AEConfig.instance().isDisassemblyCraftingEnabled() && InteractionUtil.isInAlternateUseMode(player)) {
            int itemCount = player.getItemInHand(hand).getCount();
            player.setItemInHand(hand, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(AEBlocks.CRAFTING_UNIT.stack(itemCount));
            player.getInventory().placeItemBackInInventory(new ItemStack(this.disassemblyExtra.get(), itemCount));
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    private void disassemble(ItemStack stack, Player player) {
    }
}

