/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.recipes.handlers.ChargerRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChargerRecipes {
    public static Iterable<RecipeHolder<ChargerRecipe>> getRecipes(Level level) {
        return level.getRecipeManager().byType(ChargerRecipe.TYPE).values();
    }

    @Nullable
    public static ChargerRecipe findRecipe(Level level, ItemStack input) {
        for (RecipeHolder<ChargerRecipe> recipe : ChargerRecipes.getRecipes(level)) {
            if (!((ChargerRecipe)recipe.value()).ingredient.test(input)) continue;
            return (ChargerRecipe)recipe.value();
        }
        return null;
    }

    public static boolean allowInsert(Level level, ItemStack stack) {
        return ChargerRecipes.findRecipe(level, stack) != null;
    }

    public static boolean allowExtract(Level level, ItemStack stack) {
        return ChargerRecipes.findRecipe(level, stack) == null;
    }
}

