/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.BoxFlowDirection;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytAxisBox;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.LytHBox;
import appeng.client.guidebook.document.block.LytVBox;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Set;

public class BoxTagCompiler
extends BlockTagCompiler {
    private final BoxFlowDirection direction;

    public BoxTagCompiler(BoxFlowDirection direction) {
        this.direction = direction;
    }

    @Override
    public Set<String> getTagNames() {
        return this.direction == BoxFlowDirection.ROW ? Set.of("Row") : Set.of("Column");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        int gap = MdxAttrs.getInt(compiler, parent, el, "gap", 5);
        LytAxisBox box = switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case BoxFlowDirection.ROW -> {
                LytHBox hbox = new LytHBox();
                hbox.setGap(gap);
                yield hbox;
            }
            case BoxFlowDirection.COLUMN -> {
                LytVBox vbox = new LytVBox();
                vbox.setGap(gap);
                yield vbox;
            }
        };
        compiler.compileBlockContext(el.children(), (LytBlockContainer)box);
        parent.append(box);
    }
}

