/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.FlowTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.flow.LytFlowLink;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.client.guidebook.document.flow.LytTooltipSpan;
import appeng.client.guidebook.document.interaction.ItemTooltip;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Set;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLinkCompiler
extends FlowTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("ItemLink");
    }

    @Override
    public void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
        if (itemAndId == null) {
            return;
        }
        ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
        Item item = (Item)itemAndId.getRight();
        PageAnchor linksTo = (PageAnchor)compiler.getIndex(ItemIndex.class).get(id);
        if (linksTo == null && id.getNamespace().equals(compiler.getPageId().getNamespace())) {
            parent.append(compiler.createErrorFlowContent("No page found for item " + id, el));
            return;
        }
        ItemStack stack = item.getDefaultInstance();
        if (linksTo == null || linksTo.anchor() == null && compiler.getPageId().equals((Object)linksTo.pageId())) {
            LytTooltipSpan span = new LytTooltipSpan();
            span.modifyStyle(style -> style.italic(true));
            span.appendComponent((FormattedText)stack.getHoverName());
            span.setTooltip(new ItemTooltip(stack));
            parent.append(span);
        } else {
            LytFlowLink link = new LytFlowLink();
            link.setClickCallback(screen -> screen.navigateTo(linksTo));
            link.appendComponent((FormattedText)stack.getHoverName());
            link.setTooltip(new ItemTooltip(stack));
            parent.append(link);
        }
    }
}

