/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.recipes.LytChargerRecipe;
import appeng.client.guidebook.document.block.recipes.LytCraftingRecipe;
import appeng.client.guidebook.document.block.recipes.LytInscriberRecipe;
import appeng.client.guidebook.document.block.recipes.LytSmeltingRecipe;
import appeng.client.guidebook.document.block.recipes.LytSmithingRecipe;
import appeng.client.guidebook.document.block.recipes.LytTransformRecipe;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.transform.TransformRecipe;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RecipeCompiler
extends BlockTagCompiler {
    private final List<RecipeTypeMapping<?, ?>> mappings = List.of(new RecipeTypeMapping(RecipeType.CRAFTING, LytCraftingRecipe::new), new RecipeTypeMapping(RecipeType.SMELTING, LytSmeltingRecipe::new), new RecipeTypeMapping(RecipeType.SMITHING, LytSmithingRecipe::new), new RecipeTypeMapping(InscriberRecipe.TYPE, LytInscriberRecipe::new), new RecipeTypeMapping(ChargerRecipe.TYPE, LytChargerRecipe::new), new RecipeTypeMapping(TransformRecipe.TYPE, LytTransformRecipe::new));

    @Override
    public Set<String> getTagNames() {
        return Set.of("Recipe", "RecipeFor");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        RecipeManager recipeManager = Platform.getClientRecipeManager();
        if (recipeManager == null) {
            parent.appendError(compiler, "Cannot show recipe while not in-game", el);
            return;
        }
        if ("RecipeFor".equals(el.name())) {
            Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
            if (itemAndId == null) {
                return;
            }
            ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
            Item item = (Item)itemAndId.getRight();
            for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
                LytBlock block = mapping.tryCreate(recipeManager, item);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find recipe for " + id, el);
        } else {
            ResourceLocation recipeId = MdxAttrs.getRequiredId(compiler, parent, el, "id");
            if (recipeId == null) {
                return;
            }
            RecipeHolder recipe = recipeManager.byKey(recipeId).orElse(null);
            if (recipe == null) {
                parent.appendError(compiler, "Couldn't find recipe " + recipeId, el);
                return;
            }
            for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
                LytBlock block = mapping.tryCreate(recipe);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find a handler for recipe " + recipeId, el);
        }
    }

    private record RecipeTypeMapping<T extends Recipe<C>, C extends Container>(RecipeType<T> recipeType, Function<RecipeHolder<T>, LytBlock> factory) {
        @Nullable
        LytBlock tryCreate(RecipeManager recipeManager, Item resultItem) {
            ArrayList<RecipeHolder> fallbackCandidates = new ArrayList<RecipeHolder>();
            for (RecipeHolder recipe : recipeManager.byType(this.recipeType).values()) {
                if (recipe.value().isSpecial()) {
                    fallbackCandidates.add(recipe);
                    continue;
                }
                try {
                    if (recipe.value().getResultItem(null).getItem() != resultItem) continue;
                    return this.factory.apply(recipe);
                }
                catch (Exception exception) {
                }
            }
            for (RecipeHolder recipe : fallbackCandidates) {
                try {
                    if (recipe.value().getResultItem(null).getItem() != resultItem) continue;
                    return this.factory.apply(recipe);
                }
                catch (Exception exception) {
                }
            }
            return null;
        }

        @Nullable
        LytBlock tryCreate(RecipeHolder<?> recipe) {
            if (this.recipeType == recipe.value().getType()) {
                return this.factory.apply(recipe);
            }
            return null;
        }
    }
}

