/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.recipes;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.document.block.LytSlotGrid;
import appeng.client.guidebook.document.block.recipes.LytRecipeBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import appeng.recipes.transform.TransformRecipe;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class LytTransformRecipe
extends LytRecipeBox {
    private static final ResourceLocation ARROW_LIGHT = AppEng.makeId("ae2guide/gui/recipe_arrow_light.png");
    private static final ResourceLocation ARROW_DARK = AppEng.makeId("ae2guide/gui/recipe_arrow_dark.png");
    private final TransformRecipe recipe;
    private final LytSlotGrid inputGrid;
    private final LytSlot resultSlot;

    public LytTransformRecipe(RecipeHolder<TransformRecipe> holder) {
        super(holder);
        this.recipe = (TransformRecipe)holder.value();
        this.setPadding(5);
        this.paddingTop = 15;
        this.inputGrid = LytSlotGrid.column(this.recipe.getIngredients(), true);
        this.append(this.inputGrid);
        this.resultSlot = new LytSlot(this.recipe.getResultItem());
        this.append(this.resultSlot);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect gridBounds = this.inputGrid.layout(context, x, y, availableWidth);
        LytRect resultBounds = this.resultSlot.layout(context, gridBounds.right() + 28, Math.max(y, gridBounds.y() + (gridBounds.height() - 18) / 2), availableWidth);
        return LytRect.union(gridBounds, resultBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        if (this.recipe.circumstance.isExplosion()) {
            context.renderItem(Blocks.TNT.asItem().getDefaultInstance(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
            context.renderText("Explode", DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        } else if (this.recipe.circumstance.isFluid()) {
            Fluid fluid = Fluids.EMPTY;
            if (this.recipe.circumstance.isFluidTag((TagKey<Fluid>)FluidTags.WATER)) {
                fluid = Fluids.WATER;
            } else {
                List<Fluid> fluidsForRendering = this.recipe.circumstance.getFluidsForRendering();
                if (!fluidsForRendering.isEmpty()) {
                    long cycle = System.currentTimeMillis() / 1500L;
                    fluid = fluidsForRendering.get((int)(cycle % (long)fluidsForRendering.size()));
                }
            }
            context.renderFluid(fluid, null, this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 0, 8, 8);
            context.renderText("Throw in " + Platform.getFluidDisplayName(fluid, null).getString(), DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        }
        context.fillTexturedRect(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), context.isDarkMode() ? ARROW_DARK : ARROW_LIGHT);
        super.render(context);
    }
}

