/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.Point;
import appeng.client.gui.DashPattern;
import appeng.client.gui.DashedRectangle;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.GuidebookText;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.compiler.AnchorIndexer;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytPoint;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.flow.LytFlowAnchor;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.client.guidebook.screen.GuideIconButton;
import appeng.client.guidebook.screen.GuideNavBar;
import appeng.client.guidebook.screen.GuideScreenHistory;
import appeng.client.guidebook.screen.GuideScrollbar;
import appeng.client.guidebook.style.TextAlignment;
import appeng.client.guidebook.style.TextStyle;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideScreen
extends Screen {
    private static final Logger LOG = LoggerFactory.getLogger(GuideScreen.class);
    public static final int DOCUMENT_RECT_MARGIN = 20;
    private static final DashPattern DEBUG_NODE_OUTLINE = new DashPattern(1.0f, 4.0f, 3.0f, -1, 500.0f);
    private static final DashPattern DEBUG_CONTENT_OUTLINE = new DashPattern(0.5f, 2.0f, 1.0f, Integer.MAX_VALUE, 500.0f);
    private static final ColorValue DEBUG_HOVER_OUTLINE_COLOR = new ConstantColor(0x7FFFFF00);
    private static final ResourceLocation BACKGROUND_TEXTURE = AppEng.makeId("textures/block/sky_stone_block.png");
    private final Guide guide;
    private final GuideScrollbar scrollbar;
    private final GuideScreenHistory history;
    private GuidePage currentPage;
    private final LytParagraph pageTitle;
    private Button backButton;
    private Button forwardButton;
    @Nullable
    private Screen returnToOnClose;
    @Nullable
    private String pendingScrollToAnchor;
    @Nullable
    private InteractiveElement mouseCaptureTarget;

    private GuideScreen(GuideScreenHistory history, Guide guide, PageAnchor anchor) {
        super((Component)Component.literal((String)"AE2 Guidebook"));
        this.history = history;
        this.guide = guide;
        this.scrollbar = new GuideScrollbar();
        this.pageTitle = new LytParagraph();
        this.pageTitle.setStyle(DefaultStyles.HEADING1);
        this.loadPageAndScrollTo(anchor);
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor, GuideScreenHistory history) {
        history.push(anchor);
        return new GuideScreen(history, guide, anchor);
    }

    public static GuideScreen openAtPreviousPage(Guide guide, PageAnchor fallbackPage, GuideScreenHistory history) {
        Optional<PageAnchor> historyPage = history.current();
        if (historyPage.isPresent()) {
            return new GuideScreen(history, guide, historyPage.get());
        }
        return GuideScreen.openNew(guide, fallbackPage, history);
    }

    protected void init() {
        super.init();
        this.updatePageLayout();
        this.addRenderableWidget((GuiEventListener)this.scrollbar);
        this.updateScrollbarPosition();
        GuideNavBar navbar = new GuideNavBar(this);
        this.addRenderableWidget((GuiEventListener)navbar);
        this.backButton = new GuideIconButton(this.width - 20 - 48 - 10, 2, GuideIconButton.Role.BACK, this::navigateBack);
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.forwardButton = new GuideIconButton(this.width - 20 - 32 - 5, 2, GuideIconButton.Role.FORWARD, this::navigateForward);
        this.addRenderableWidget((GuiEventListener)this.forwardButton);
        GuideIconButton closeButton = new GuideIconButton(this.width - 20 - 16, 2, GuideIconButton.Role.CLOSE, this::onClose);
        this.addRenderableWidget((GuiEventListener)closeButton);
        this.updateTopNavButtons();
    }

    private void updateScrollbarPosition() {
        LytRect docRect = this.getDocumentRect();
        this.scrollbar.move(docRect.right(), docRect.y(), docRect.height());
    }

    public void tick() {
        this.processPendingScrollTo();
        if (this.currentPage != null) {
            GuideScreen.tickNode(this.currentPage.document());
        }
    }

    private static void tickNode(LytNode node) {
        node.tick();
        for (LytNode lytNode : node.getChildren()) {
            GuideScreen.tickNode(lytNode);
        }
    }

    private void processPendingScrollTo() {
        LytFlowAnchor flowAnchor;
        if (this.pendingScrollToAnchor == null) {
            return;
        }
        String anchor = this.pendingScrollToAnchor;
        this.pendingScrollToAnchor = null;
        AnchorIndexer indexer = new AnchorIndexer(this.currentPage.document());
        AnchorIndexer.AnchorTarget targetAnchor = indexer.get(anchor);
        if (targetAnchor == null) {
            LOG.warn("Failed to find anchor {} in page {}", (Object)anchor, (Object)this.currentPage);
            return;
        }
        LytFlowContent lytFlowContent = targetAnchor.flowContent();
        if (lytFlowContent instanceof LytFlowAnchor && (flowAnchor = (LytFlowAnchor)lytFlowContent).getLayoutY().isPresent()) {
            this.scrollbar.setScrollAmount(flowAnchor.getLayoutY().getAsInt());
        } else {
            LytRect bounds = targetAnchor.blockNode().getBounds();
            this.scrollbar.setScrollAmount(bounds.y());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateTopNavButtons();
        this.renderSkyStoneBackground(guiGraphics);
        LytRect documentRect = this.getDocumentRect();
        guiGraphics.fill(documentRect.x(), documentRect.y(), documentRect.right(), documentRect.bottom(), -2144128205);
        LytRect documentViewport = this.getDocumentViewport();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(documentRect.x() - documentViewport.x()), (float)(documentRect.y() - documentViewport.y()), 0.0f);
        LytDocument document = this.currentPage.document();
        SimpleRenderContext context = new SimpleRenderContext(documentViewport, guiGraphics);
        guiGraphics.enableScissor(documentRect.x(), documentRect.y(), documentRect.right(), documentRect.bottom());
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        document.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        document.render(context);
        guiGraphics.disableScissor();
        if (AEConfig.instance().isShowDebugGuiOverlays()) {
            GuideScreen.renderHoverOutline(document, context);
        }
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        this.renderExternalpageSource(documentRect, context);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        poseStack.popPose();
        if (document.getHoveredElement() != null) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderExternalpageSource(LytRect documentRect, SimpleRenderContext context) {
        String externalSource = this.getExternalSourceName();
        if (externalSource != null) {
            LytParagraph paragraph = new LytParagraph();
            paragraph.appendText(GuidebookText.ContentFrom.text().getString() + " ");
            LytFlowSpan sourceSpan = new LytFlowSpan();
            sourceSpan.appendText(externalSource);
            sourceSpan.setStyle(TextStyle.builder().italic(true).build());
            paragraph.append(sourceSpan);
            paragraph.setStyle(TextStyle.builder().alignment(TextAlignment.RIGHT).build());
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            paragraph.layout(layoutContext, documentRect.x(), documentRect.bottom(), documentRect.width());
            MultiBufferSource.BufferSource buffers = context.beginBatch();
            paragraph.renderBatch(context, (MultiBufferSource)buffers);
            context.endBatch(buffers);
        }
    }

    @Nullable
    private String getExternalSourceName() {
        String sourcePackId = this.currentPage.sourcePack();
        if (sourcePackId.startsWith("mod:")) {
            String modId = sourcePackId.substring("mod:".length());
            if (this.guide.getDefaultNamespace().equals(modId)) {
                return null;
            }
            return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(null);
        }
        if (this.guide.getDefaultNamespace().equals(sourcePackId)) {
            return null;
        }
        Pack pack = Minecraft.getInstance().getResourcePackRepository().getPack(sourcePackId);
        if (pack != null) {
            return pack.getDescription().getString();
        }
        return null;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    private void renderTitle(LytRect documentRect, SimpleRenderContext context) {
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        this.pageTitle.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        context.fillRect(documentRect.x(), documentRect.y() - 1, documentRect.width(), 1, (ColorValue)SymbolicColor.HEADER1_SEPARATOR);
    }

    private void renderSkyStoneBackground(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        guiGraphics.blit(BACKGROUND_TEXTURE, 0, 0, 0, 0.0f, 0.0f, this.width, this.height, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NeoForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, guiGraphics));
    }

    private void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        Point docPos = this.getDocumentPoint(x, y);
        if (docPos == null) {
            return;
        }
        LytDocument.HitTestResult hoveredElement = this.currentPage.document().getHoveredElement();
        if (hoveredElement != null) {
            GuideScreen.dispatchInteraction(hoveredElement, el -> el.getTooltip(docPos.getX(), docPos.getY())).ifPresent(tooltip -> this.renderTooltip(guiGraphics, (GuideTooltip)tooltip, x, y));
        }
    }

    private static void renderHoverOutline(LytDocument document, SimpleRenderContext context) {
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement != null) {
            LytNode lytNode = hoveredElement.node();
            if (lytNode instanceof LytBlock) {
                LytBlock block = (LytBlock)lytNode;
                LytRect bounds = block.getBounds();
                if (block.getMarginTop() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginTop()).move(0, -block.getMarginTop()), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginBottom() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginBottom()).move(0, bounds.height()), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginLeft() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginLeft()).move(-block.getMarginLeft(), 0), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginRight() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginRight()).move(bounds.width(), 0), DEBUG_HOVER_OUTLINE_COLOR);
                }
            }
            DashedRectangle.render(context.poseStack(), hoveredElement.node().getBounds(), DEBUG_NODE_OUTLINE, 0.0f);
            if (hoveredElement.content() != null && (lytNode = hoveredElement.node()) instanceof LytFlowContainer) {
                LytFlowContainer flowContainer = (LytFlowContainer)((Object)lytNode);
                flowContainer.enumerateContentBounds(hoveredElement.content()).forEach(bound -> DashedRectangle.render(context.poseStack(), bound, DEBUG_CONTENT_OUTLINE, 0.0f));
            }
            LytRect bounds = hoveredElement.node().getBounds();
            context.renderText(hoveredElement.node().getClass().getName(), DefaultStyles.BASE_STYLE, bounds.x(), bounds.bottom());
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        Point docPoint;
        super.mouseMoved(mouseX, mouseY);
        if (this.mouseCaptureTarget != null) {
            Point docPointUnclamped = this.getDocumentPointUnclamped(mouseX, mouseY);
            this.mouseCaptureTarget.mouseMoved(this, docPointUnclamped.getX(), docPointUnclamped.getY());
        }
        if ((docPoint = this.getDocumentPoint(mouseX, mouseY)) != null) {
            this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseMoved(this, docPoint.getX(), docPoint.getY()));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            if (button == 3) {
                this.navigateBack();
            } else if (button == 4) {
                this.navigateForward();
            }
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseClicked(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Point docPoint;
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.mouseCaptureTarget != null) {
            InteractiveElement currentTarget = this.mouseCaptureTarget;
            Point docPointUnclamped = this.getDocumentPointUnclamped(mouseX, mouseY);
            currentTarget.mouseReleased(this, docPointUnclamped.getX(), docPointUnclamped.getY(), button);
            this.releaseMouseCapture(currentTarget);
        }
        if ((docPoint = this.getDocumentPoint(mouseX, mouseY)) != null) {
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseReleased(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public void navigateTo(ResourceLocation pageId) {
        this.navigateTo(new PageAnchor(pageId, null));
    }

    public void navigateTo(PageAnchor anchor) {
        if (this.currentPage.id().equals((Object)anchor.pageId())) {
            this.pendingScrollToAnchor = anchor.anchor();
            if (anchor.anchor() != null) {
                this.history.push(anchor);
            }
            return;
        }
        this.loadPageAndScrollTo(anchor);
        this.history.push(anchor);
    }

    private void navigateForward() {
        this.history.forward().ifPresent(this::loadPageAndScrollTo);
    }

    private void navigateBack() {
        this.history.back().ifPresent(this::loadPageAndScrollTo);
    }

    private void loadPageAndScrollTo(PageAnchor anchor) {
        this.loadPage(anchor.pageId());
        this.scrollbar.setScrollAmount(0);
        this.updatePageLayout();
        this.pendingScrollToAnchor = anchor.anchor();
    }

    public void reloadPage() {
        this.loadPage(this.currentPage.id());
        this.updatePageLayout();
    }

    private void loadPage(ResourceLocation pageId) {
        this.closePage();
        GuidePageTexture.releaseUsedTextures();
        ParsedGuidePage page = this.guide.getParsedPage(pageId);
        if (page == null) {
            page = this.buildNotFoundPage(pageId);
        }
        this.currentPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
        this.pageTitle.clearContent();
        for (LytFlowContent flowContent : this.extractPageTitle(this.currentPage)) {
            this.pageTitle.append(flowContent);
        }
    }

    private void closePage() {
        if (this.mouseCaptureTarget != null) {
            this.releaseMouseCapture(this.mouseCaptureTarget);
        }
    }

    private Iterable<LytFlowContent> extractPageTitle(GuidePage page) {
        for (LytBlock block : page.document().getBlocks()) {
            if (!(block instanceof LytHeading)) continue;
            LytHeading heading = (LytHeading)block;
            if (heading.getDepth() != 1) break;
            page.document().removeChild(heading);
            return heading.getContent();
        }
        return List.of();
    }

    private ParsedGuidePage buildNotFoundPage(ResourceLocation pageId) {
        String pageSource = "# Page not Found\n\nPage \"" + pageId + "\" could not be found.";
        return PageCompiler.parse(pageId.getNamespace(), pageId, pageSource);
    }

    public void removed() {
        super.removed();
        GuidePageTexture.releaseUsedTextures();
    }

    public void setReturnToOnClose(@Nullable Screen screen) {
        this.returnToOnClose = screen;
    }

    public void openUrl(String href) {
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("Can't parse '{}' as URL in '{}'", (Object)href, (Object)this.currentPage);
            return;
        }
        if (uri.getScheme() != null) {
            if (((Boolean)this.minecraft.options.chatLinksPrompt().get()).booleanValue()) {
                this.minecraft.setScreen((Screen)new ConfirmLinkScreen(doOpen -> {
                    if (doOpen) {
                        Util.getPlatform().openUri(uri);
                    }
                    this.minecraft.setScreen((Screen)this);
                }, href, false));
            } else {
                Util.getPlatform().openUri(uri);
            }
        } else {
            ResourceLocation pageId = AppEng.makeId(uri.getSchemeSpecificPart());
            PageAnchor anchor = new PageAnchor(pageId, uri.getFragment());
            this.history.push(anchor);
            this.loadPageAndScrollTo(anchor);
        }
    }

    private boolean dispatchEvent(int x, int y, EventInvoker invoker) {
        return this.dispatchInteraction(x, y, el -> {
            if (invoker.invoke((InteractiveElement)el)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }).orElse(false);
    }

    private <T> Optional<T> dispatchInteraction(int x, int y, Function<InteractiveElement, Optional<T>> invoker) {
        LytDocument.HitTestResult underCursor = this.currentPage.document().pick(x, y);
        if (underCursor != null) {
            return GuideScreen.dispatchInteraction(underCursor, invoker);
        }
        return Optional.empty();
    }

    private static <T> Optional<T> dispatchInteraction(LytDocument.HitTestResult receiver, Function<InteractiveElement, Optional<T>> invoker) {
        InteractiveElement interactiveEl;
        Optional<T> result;
        for (LytFlowContent el = receiver.content(); el != null; el = el.getFlowParent()) {
            if (!(el instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)el))).isPresent()) continue;
            return result;
        }
        for (LytNode node = receiver.node(); node != null; node = node.getParent()) {
            if (!(node instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)node))).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public void afterMouseMove() {
        super.afterMouseMove();
        MouseHandler mouseHandler = this.minecraft.mouseHandler;
        double scale = (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
        double x = mouseHandler.xpos() * scale;
        double y = mouseHandler.ypos() * scale;
        LytDocument document = this.currentPage.document();
        if (this.getChildAt(x, y).isPresent()) {
            document.setHoveredElement(null);
            return;
        }
        Point docPoint = this.getDocumentPoint(x, y);
        if (docPoint != null) {
            LytDocument.HitTestResult hoveredEl = document.pick(docPoint.getX(), docPoint.getY());
            document.setHoveredElement(hoveredEl);
        } else {
            document.setHoveredElement(null);
        }
    }

    @Nullable
    public Point getDocumentPoint(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        if (screenX >= (double)documentRect.x() && screenX < (double)documentRect.right() && screenY >= (double)documentRect.y() && screenY < (double)documentRect.bottom()) {
            return this.getDocumentPointUnclamped(screenX, screenY);
        }
        return null;
    }

    private Point getDocumentPointUnclamped(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        int docX = (int)Math.round(screenX - (double)documentRect.x());
        int docY = (int)Math.round(screenY + (double)this.scrollbar.getScrollAmount() - (double)documentRect.y());
        return new Point(docX, docY);
    }

    public LytPoint getScreenPoint(LytPoint documentPoint) {
        LytRect documentRect = this.getDocumentRect();
        LytRect documentViewport = this.getDocumentViewport();
        float x = documentPoint.x() - (float)documentViewport.x();
        float y = documentPoint.y() - (float)documentViewport.y();
        return new LytPoint((float)documentRect.x() + x, (float)documentRect.y() + y);
    }

    private LytRect getDocumentRect() {
        int margin = 20;
        int marginTop = Math.max(margin, 5 + this.pageTitle.getBounds().height());
        return new LytRect(margin, marginTop, this.width - 2 * margin, this.height - margin - marginTop);
    }

    private LytRect getDocumentViewport() {
        LytRect documentRect = this.getDocumentRect();
        return new LytRect(0, this.scrollbar.getScrollAmount(), documentRect.width(), documentRect.height());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!super.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return this.scrollbar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return true;
    }

    private void renderTooltip(GuiGraphics guiGraphics, GuideTooltip tooltip, int mouseX, int mouseY) {
        ClientTooltipComponent line;
        int i;
        Minecraft minecraft = Minecraft.getInstance();
        List<ClientTooltipComponent> clientLines = tooltip.getLines();
        if (clientLines.isEmpty()) {
            return;
        }
        int frameWidth = 0;
        int frameHeight = clientLines.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clientTooltipComponent : clientLines) {
            frameWidth = Math.max(frameWidth, clientTooltipComponent.getWidth(minecraft.font));
            frameHeight += clientTooltipComponent.getHeight();
        }
        if (!tooltip.getIcon().isEmpty()) {
            frameWidth += 18;
            frameHeight = Math.max(frameHeight, 18);
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + frameWidth > this.width) {
            x -= 28 + frameWidth;
        }
        if (y + frameHeight + 6 > this.height) {
            y = this.height - frameHeight - 6;
        }
        int zOffset = 400;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)frameWidth, (int)frameHeight, (int)zOffset);
        if (!tooltip.getIcon().isEmpty()) {
            x += 18;
        }
        PoseStack poseStack = guiGraphics.pose();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, (double)zOffset);
        int currentY = y;
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.renderText(minecraft.font, x, currentY, poseStack.last().pose(), bufferSource);
            currentY += line.getHeight() + (i == 0 ? 2 : 0);
        }
        bufferSource.endBatch();
        currentY = y;
        if (!tooltip.getIcon().isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, (float)zOffset);
            guiGraphics.renderItem(tooltip.getIcon(), x - 18, y);
            poseStack.popPose();
        }
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.renderImage(minecraft.font, x, currentY, guiGraphics);
            currentY += line.getHeight() + (i == 0 ? 2 : 0);
        }
        poseStack.popPose();
    }

    private void updatePageLayout() {
        this.updateTitleLayout();
        LytRect docViewport = this.getDocumentViewport();
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        LytDocument document = this.currentPage.document();
        document.updateLayout(context, docViewport.width());
        this.scrollbar.setContentHeight(document.getContentHeight());
    }

    private void updateTitleLayout() {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        int availableWidth = this.width;
        availableWidth -= 40;
        availableWidth -= 37;
        if ((availableWidth -= 10) < 0) {
            availableWidth = 0;
        }
        this.pageTitle.layout(context, 0, 0, availableWidth);
        int height = this.pageTitle.getBounds().height();
        LytRect documentRect = this.getDocumentRect();
        int titleY = (documentRect.y() - height) / 2;
        this.pageTitle.layout(context, documentRect.x() + 5, titleY, availableWidth);
        this.updateScrollbarPosition();
    }

    public ResourceLocation getCurrentPageId() {
        return this.currentPage.id();
    }

    private void updateTopNavButtons() {
        this.backButton.active = this.history.peekBack().isPresent();
        this.forwardButton.active = this.history.peekForward().isPresent();
    }

    public PageCollection getGuide() {
        return this.guide;
    }

    @Nullable
    public InteractiveElement getMouseCaptureTarget() {
        return this.mouseCaptureTarget;
    }

    public void captureMouse(InteractiveElement element) {
        if (this.mouseCaptureTarget != element) {
            if (this.mouseCaptureTarget != null) {
                this.releaseMouseCapture(this.mouseCaptureTarget);
            }
            this.mouseCaptureTarget = element;
        }
    }

    public void releaseMouseCapture(InteractiveElement element) {
        if (this.mouseCaptureTarget == element) {
            this.mouseCaptureTarget = null;
            element.mouseCaptureLost();
            if (this.mouseCaptureTarget != null) {
                throw new IllegalStateException("Element " + element + " recaptured the mouse in its release event");
            }
        }
    }

    public void onClose() {
        if (this.minecraft != null && this.minecraft.screen == this && this.returnToOnClose != null) {
            this.minecraft.setScreen(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        this.closePage();
        super.onClose();
    }

    @FunctionalInterface
    static interface EventInvoker {
        public boolean invoke(InteractiveElement var1);
    }
}

