/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.ParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class LightningArcParticleData
implements ParticleOptions {
    public final Vec3 target;
    public static final ParticleOptions.Deserializer<LightningArcParticleData> DESERIALIZER = new ParticleOptions.Deserializer<LightningArcParticleData>(){

        public LightningArcParticleData fromCommand(ParticleType<LightningArcParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float x = reader.readFloat();
            reader.expect(' ');
            float y = reader.readFloat();
            reader.expect(' ');
            float z = reader.readFloat();
            return new LightningArcParticleData(new Vec3((double)x, (double)y, (double)z));
        }

        public LightningArcParticleData fromNetwork(ParticleType<LightningArcParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            float x = buffer.readFloat();
            float y = buffer.readFloat();
            float z = buffer.readFloat();
            return new LightningArcParticleData(new Vec3((double)x, (double)y, (double)z));
        }
    };

    public LightningArcParticleData(Vec3 target) {
        this.target = target;
    }

    public ParticleType<?> getType() {
        return ParticleTypes.LIGHTNING_ARC;
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeFloat((float)this.target.x);
        buffer.writeFloat((float)this.target.y);
        buffer.writeFloat((float)this.target.z);
    }

    public String writeToString() {
        return String.format(Locale.ROOT, "%.2f %.2f %.2f", this.target.x, this.target.y, this.target.z);
    }
}

