/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network;

import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import appeng.core.network.bidirectional.ConfigValuePacket;
import appeng.core.network.clientbound.AssemblerAnimationPacket;
import appeng.core.network.clientbound.BlockTransitionEffectPacket;
import appeng.core.network.clientbound.ClearPatternAccessTerminalPacket;
import appeng.core.network.clientbound.CompassResponsePacket;
import appeng.core.network.clientbound.CraftConfirmPlanPacket;
import appeng.core.network.clientbound.CraftingJobStatusPacket;
import appeng.core.network.clientbound.CraftingStatusPacket;
import appeng.core.network.clientbound.GuiDataSyncPacket;
import appeng.core.network.clientbound.ItemTransitionEffectPacket;
import appeng.core.network.clientbound.LightningPacket;
import appeng.core.network.clientbound.MEInventoryUpdatePacket;
import appeng.core.network.clientbound.MatterCannonPacket;
import appeng.core.network.clientbound.MockExplosionPacket;
import appeng.core.network.clientbound.NetworkStatusPacket;
import appeng.core.network.clientbound.PatternAccessTerminalPacket;
import appeng.core.network.clientbound.SetLinkStatusPacket;
import appeng.core.network.serverbound.ColorApplicatorSelectColorPacket;
import appeng.core.network.serverbound.CompassRequestPacket;
import appeng.core.network.serverbound.ConfigButtonPacket;
import appeng.core.network.serverbound.ConfirmAutoCraftPacket;
import appeng.core.network.serverbound.FillCraftingGridFromRecipePacket;
import appeng.core.network.serverbound.GuiActionPacket;
import appeng.core.network.serverbound.HotkeyPacket;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.core.network.serverbound.MEInteractionPacket;
import appeng.core.network.serverbound.MouseWheelPacket;
import appeng.core.network.serverbound.PartLeftClickPacket;
import appeng.core.network.serverbound.SelectKeyTypePacket;
import appeng.core.network.serverbound.SwapSlotsPacket;
import appeng.core.network.serverbound.SwitchGuisPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class InitNetwork {
    public static void init(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("ae2");
        InitNetwork.clientbound(registrar, AssemblerAnimationPacket.class, AssemblerAnimationPacket::decode);
        InitNetwork.clientbound(registrar, BlockTransitionEffectPacket.class, BlockTransitionEffectPacket::decode);
        InitNetwork.clientbound(registrar, ClearPatternAccessTerminalPacket.class, ClearPatternAccessTerminalPacket::decode);
        InitNetwork.clientbound(registrar, CompassResponsePacket.class, CompassResponsePacket::decode);
        InitNetwork.clientbound(registrar, CraftConfirmPlanPacket.class, CraftConfirmPlanPacket::decode);
        InitNetwork.clientbound(registrar, CraftingJobStatusPacket.class, CraftingJobStatusPacket::decode);
        InitNetwork.clientbound(registrar, CraftingStatusPacket.class, CraftingStatusPacket::decode);
        InitNetwork.clientbound(registrar, GuiDataSyncPacket.class, GuiDataSyncPacket::decode);
        InitNetwork.clientbound(registrar, ItemTransitionEffectPacket.class, ItemTransitionEffectPacket::decode);
        InitNetwork.clientbound(registrar, LightningPacket.class, LightningPacket::decode);
        InitNetwork.clientbound(registrar, MatterCannonPacket.class, MatterCannonPacket::decode);
        InitNetwork.clientbound(registrar, MEInventoryUpdatePacket.class, MEInventoryUpdatePacket::decode);
        InitNetwork.clientbound(registrar, MockExplosionPacket.class, MockExplosionPacket::decode);
        InitNetwork.clientbound(registrar, NetworkStatusPacket.class, NetworkStatusPacket::decode);
        InitNetwork.clientbound(registrar, PatternAccessTerminalPacket.class, PatternAccessTerminalPacket::decode);
        InitNetwork.clientbound(registrar, SetLinkStatusPacket.class, SetLinkStatusPacket::decode);
        InitNetwork.serverbound(registrar, ColorApplicatorSelectColorPacket.class, ColorApplicatorSelectColorPacket::decode);
        InitNetwork.serverbound(registrar, CompassRequestPacket.class, CompassRequestPacket::decode);
        InitNetwork.serverbound(registrar, ConfigButtonPacket.class, ConfigButtonPacket::decode);
        InitNetwork.serverbound(registrar, ConfirmAutoCraftPacket.class, ConfirmAutoCraftPacket::decode);
        InitNetwork.serverbound(registrar, FillCraftingGridFromRecipePacket.class, FillCraftingGridFromRecipePacket::decode);
        InitNetwork.serverbound(registrar, GuiActionPacket.class, GuiActionPacket::decode);
        InitNetwork.serverbound(registrar, HotkeyPacket.class, HotkeyPacket::decode);
        InitNetwork.serverbound(registrar, InventoryActionPacket.class, InventoryActionPacket::decode);
        InitNetwork.serverbound(registrar, MEInteractionPacket.class, MEInteractionPacket::decode);
        InitNetwork.serverbound(registrar, MouseWheelPacket.class, MouseWheelPacket::decode);
        InitNetwork.serverbound(registrar, PartLeftClickPacket.class, PartLeftClickPacket::decode);
        InitNetwork.serverbound(registrar, SelectKeyTypePacket.class, SelectKeyTypePacket::decode);
        InitNetwork.serverbound(registrar, SwapSlotsPacket.class, SwapSlotsPacket::decode);
        InitNetwork.serverbound(registrar, SwitchGuisPacket.class, SwitchGuisPacket::decode);
        InitNetwork.bidirectional(registrar, ConfigValuePacket.class, ConfigValuePacket::decode);
    }

    private static <T extends ClientboundPacket> void clientbound(IPayloadRegistrar registrar, Class<T> packetClass, FriendlyByteBuf.Reader<T> reader) {
        ResourceLocation id = CustomAppEngPayload.makeId(packetClass);
        registrar.play(id, reader, builder -> builder.client(ClientboundPacket::handleOnClient));
    }

    private static <T extends ServerboundPacket> void serverbound(IPayloadRegistrar registrar, Class<T> packetClass, FriendlyByteBuf.Reader<T> reader) {
        ResourceLocation id = CustomAppEngPayload.makeId(packetClass);
        registrar.play(id, reader, builder -> builder.server(ServerboundPacket::handleOnServer));
    }

    private static <T extends ServerboundPacket & ClientboundPacket> void bidirectional(IPayloadRegistrar registrar, Class<T> packetClass, FriendlyByteBuf.Reader<T> reader) {
        ResourceLocation id = CustomAppEngPayload.makeId(packetClass);
        registrar.play(id, reader, builder -> {
            builder.client((rec$, x$0) -> ((ClientboundPacket)rec$).handleOnClient(x$0));
            builder.server((rec$, x$0) -> ((ServerboundPacket)rec$).handleOnServer(x$0));
        });
    }
}

