/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network;

import appeng.core.AppEng;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.ServerboundPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetworkHandler {
    private static final NetworkHandler instance = new NetworkHandler();

    public static NetworkHandler instance() {
        return instance;
    }

    public void sendToAll(ClientboundPacket message) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{message});
    }

    public void sendTo(ClientboundPacket message, ServerPlayer player) {
        player.connection.send((CustomPacketPayload)message);
    }

    public void sendToAllAround(ClientboundPacket message, PacketDistributor.TargetPoint point) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            PacketDistributor.NEAR.with((Object)point).send(new CustomPacketPayload[]{message});
        }
    }

    public void sendToServer(ServerboundPacket message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{message});
    }
}

