/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.bidirectional;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.ServerboundPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record ConfigValuePacket(String name, String value) implements ClientboundPacket,
ServerboundPacket
{
    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, T value) {
        this(setting.getName(), value.name());
        if (!setting.getValues().contains(value)) {
            throw new IllegalStateException(value + " not a valid value for " + setting);
        }
    }

    public <T extends Enum<T>> ConfigValuePacket(Setting<T> setting, IConfigManager configManager) {
        this(setting, setting.getValue(configManager));
    }

    public static ConfigValuePacket decode(FriendlyByteBuf stream) {
        String name = stream.readUtf();
        String value = stream.readUtf();
        return new ConfigValuePacket(name, value);
    }

    public void write(FriendlyByteBuf data) {
        data.writeUtf(this.name);
        data.writeUtf(this.value);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)abstractContainerMenu;
            this.loadSetting(configurableObject);
        }
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)abstractContainerMenu;
            this.loadSetting(configurableObject);
        }
    }

    private void loadSetting(IConfigurableObject configurableObject) {
        IConfigManager cm = configurableObject.getConfigManager();
        for (Setting<?> setting : cm.getSettings()) {
            if (!setting.getName().equals(this.name)) continue;
            setting.setFromString(cm, this.value);
            break;
        }
    }
}

