/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.api.stacks.AEKey;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.network.ClientboundPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record AssemblerAnimationPacket(BlockPos pos, byte rate, AEKey what) implements ClientboundPacket
{
    public static AssemblerAnimationPacket decode(FriendlyByteBuf data) {
        BlockPos pos = data.readBlockPos();
        byte rate = data.readByte();
        AEKey what = AEKey.readKey(data);
        return new AssemblerAnimationPacket(pos, rate, what);
    }

    public void write(FriendlyByteBuf data) {
        data.writeBlockPos(this.pos);
        data.writeByte(this.rate);
        AEKey.writeKey(data, this.what);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        BlockEntity te = player.getCommandSenderWorld().getBlockEntity(this.pos);
        if (te instanceof MolecularAssemblerBlockEntity) {
            MolecularAssemblerBlockEntity ma = (MolecularAssemblerBlockEntity)te;
            ma.setAnimationStatus(new AssemblerAnimationStatus(this.rate, this.what.wrapForDisplayOrFilter()));
        }
    }
}

