/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.core.network.ClientboundPacket;
import appeng.menu.AEBaseMenu;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record GuiDataSyncPacket(int containerId, byte[] syncData) implements ClientboundPacket
{
    public GuiDataSyncPacket(int containerId, Consumer<FriendlyByteBuf> writer) {
        this(containerId, GuiDataSyncPacket.createSyncData(writer));
    }

    private static byte[] createSyncData(Consumer<FriendlyByteBuf> writer) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        writer.accept(buffer);
        byte[] result = new byte[buffer.readableBytes()];
        buffer.readBytes(result);
        return result;
    }

    public static GuiDataSyncPacket decode(FriendlyByteBuf data) {
        int containerId = data.readVarInt();
        byte[] syncData = data.readByteArray();
        return new GuiDataSyncPacket(containerId, syncData);
    }

    public void write(FriendlyByteBuf data) {
        data.writeVarInt(this.containerId);
        data.writeByteArray(this.syncData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        AbstractContainerMenu c = player.containerMenu;
        if (c instanceof AEBaseMenu) {
            AEBaseMenu baseMenu = (AEBaseMenu)c;
            if (c.containerId == this.containerId) {
                baseMenu.receiveServerSyncData(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.syncData)));
            }
        }
    }
}

