/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.network.ClientboundPacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record LightningPacket(double x, double y, double z) implements ClientboundPacket
{
    public static LightningPacket decode(FriendlyByteBuf stream) {
        float x = stream.readFloat();
        float y = stream.readFloat();
        float z = stream.readFloat();
        return new LightningPacket(x, y, z);
    }

    public void write(FriendlyByteBuf data) {
        data.writeFloat((float)this.x);
        data.writeFloat((float)this.y);
        data.writeFloat((float)this.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        try {
            if (AEConfig.instance().isEnableEffects()) {
                player.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.LIGHTNING, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

