/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.core.network.ClientboundPacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record MockExplosionPacket(double x, double y, double z) implements ClientboundPacket
{
    public static MockExplosionPacket decode(FriendlyByteBuf data) {
        double x = data.readDouble();
        double y = data.readDouble();
        double z = data.readDouble();
        return new MockExplosionPacket(x, y, z);
    }

    public void write(FriendlyByteBuf data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        Level level = player.getCommandSenderWorld();
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
    }
}

