/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.client.gui.me.patternaccess.PatternAccessTermScreen;
import appeng.core.network.ClientboundPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record PatternAccessTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) implements ClientboundPacket
{
    public static PatternAccessTerminalPacket decode(FriendlyByteBuf stream) {
        long inventoryId = stream.readVarLong();
        boolean fullUpdate = stream.readBoolean();
        int inventorySize = 0;
        long sortBy = 0L;
        PatternContainerGroup group = null;
        if (fullUpdate) {
            inventorySize = stream.readVarInt();
            sortBy = stream.readVarLong();
            group = PatternContainerGroup.readFromPacket(stream);
        }
        int slotsCount = stream.readVarInt();
        Int2ObjectArrayMap slots = new Int2ObjectArrayMap(slotsCount);
        for (int i = 0; i < slotsCount; ++i) {
            int slot = stream.readVarInt();
            ItemStack item = stream.readItem();
            slots.put(slot, (Object)item);
        }
        return new PatternAccessTerminalPacket(fullUpdate, inventoryId, inventorySize, sortBy, group, (Int2ObjectMap<ItemStack>)slots);
    }

    public void write(FriendlyByteBuf data) {
        data.writeVarLong(this.inventoryId);
        data.writeBoolean(this.fullUpdate);
        if (this.fullUpdate) {
            data.writeVarInt(this.inventorySize);
            data.writeVarLong(this.sortBy);
            this.group.writeToPacket(data);
        }
        data.writeVarInt(this.slots.size());
        for (Int2ObjectMap.Entry entry : this.slots.int2ObjectEntrySet()) {
            data.writeVarInt(entry.getIntKey());
            data.writeItem((ItemStack)entry.getValue());
        }
    }

    public static PatternAccessTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(true, inventoryId, inventorySize, sortBy, group, slots);
    }

    public static PatternAccessTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        return new PatternAccessTerminalPacket(false, inventoryId, 0, 0L, null, slots);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PatternAccessTermScreen) {
            PatternAccessTermScreen patternAccessTerminal = (PatternAccessTermScreen)screen;
            if (this.fullUpdate) {
                patternAccessTerminal.postFullUpdate(this.inventoryId, this.sortBy, this.group, this.inventorySize, this.slots);
            } else {
                patternAccessTerminal.postIncrementalUpdate(this.inventoryId, this.slots);
            }
        }
    }
}

