/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.clientbound;

import appeng.api.storage.ILinkStatus;
import appeng.api.storage.LinkStatus;
import appeng.core.network.ClientboundPacket;
import appeng.menu.guisync.LinkStatusAwareMenu;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record SetLinkStatusPacket(ILinkStatus linkStatus) implements ClientboundPacket
{
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.linkStatus.connected());
        buffer.writeOptional(Optional.ofNullable(this.linkStatus.statusDescription()), FriendlyByteBuf::writeComponent);
    }

    public static SetLinkStatusPacket decode(FriendlyByteBuf buffer) {
        return new SetLinkStatusPacket(new LinkStatus(buffer.readBoolean(), buffer.readOptional(FriendlyByteBuf::readComponentTrusted).orElse(null)));
    }

    @Override
    public void handleOnClient(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof LinkStatusAwareMenu) {
            LinkStatusAwareMenu linkStatusAwareMenu = (LinkStatusAwareMenu)abstractContainerMenu;
            linkStatusAwareMenu.setLinkStatus(this.linkStatus);
        }
    }
}

