/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.api.util.AEColor;
import appeng.core.network.ServerboundPacket;
import appeng.items.tools.powered.ColorApplicatorItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record ColorApplicatorSelectColorPacket(@Nullable AEColor color) implements ServerboundPacket
{
    public static ColorApplicatorSelectColorPacket decode(FriendlyByteBuf stream) {
        AEColor color = null;
        if (stream.readBoolean()) {
            color = (AEColor)stream.readEnum(AEColor.class);
        }
        return new ColorApplicatorSelectColorPacket(color);
    }

    public void write(FriendlyByteBuf data) {
        if (this.color != null) {
            data.writeBoolean(true);
            data.writeEnum((Enum)this.color);
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        ColorApplicatorSelectColorPacket.switchColor(player.getMainHandItem(), this.color);
        ColorApplicatorSelectColorPacket.switchColor(player.getOffhandItem(), this.color);
    }

    private static void switchColor(ItemStack stack, AEColor color) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ColorApplicatorItem) {
            ColorApplicatorItem colorApplicator = (ColorApplicatorItem)item;
            colorApplicator.setActiveColor(stack, color);
        }
    }
}

