/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.core.network.ServerboundPacket;
import appeng.menu.AEBaseMenu;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public record GuiActionPacket(int containerId, String actionName, @Nullable String jsonPayload) implements ServerboundPacket
{
    public static GuiActionPacket decode(FriendlyByteBuf data) {
        int containerId = data.readVarInt();
        String actionName = data.readUtf();
        String jsonPayload = data.readOptional(FriendlyByteBuf::readUtf).orElse(null);
        return new GuiActionPacket(containerId, actionName, jsonPayload);
    }

    public void write(FriendlyByteBuf data) {
        data.writeVarInt(this.containerId);
        data.writeUtf(this.actionName);
        data.writeOptional(Optional.ofNullable(this.jsonPayload), FriendlyByteBuf::writeUtf);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        AbstractContainerMenu c = player.containerMenu;
        if (c instanceof AEBaseMenu) {
            AEBaseMenu baseMenu = (AEBaseMenu)c;
            if (c.containerId == this.containerId) {
                baseMenu.receiveClientAction(this.actionName, this.jsonPayload);
            }
        }
    }
}

