/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.api.features.HotkeyAction;
import appeng.client.Hotkey;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.network.ServerboundPacket;
import appeng.hotkeys.HotkeyActions;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record HotkeyPacket(String hotkey) implements ServerboundPacket
{
    public HotkeyPacket(Hotkey hotkey) {
        this(hotkey.name());
    }

    public static HotkeyPacket decode(FriendlyByteBuf stream) {
        String hotkey = stream.readUtf();
        return new HotkeyPacket(hotkey);
    }

    public void write(FriendlyByteBuf data) {
        data.writeUtf(this.hotkey);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        List<HotkeyAction> actions = HotkeyActions.REGISTRY.get(this.hotkey);
        if (actions == null) {
            player.sendSystemMessage((Component)PlayerMessages.UnknownHotkey.text().copy().append((Component)Component.translatable((String)("key.ae2." + this.hotkey))));
            AELog.warn("Player %s tried using unknown hotkey \"%s\"", player, this.hotkey);
            return;
        }
        for (HotkeyAction action : actions) {
            if (action.run((Player)player)) break;
        }
    }
}

