/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.core.network.ServerboundPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.Platform;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record InventoryActionPacket(InventoryAction action, int slot, long extraId, ItemStack slotItem) implements ServerboundPacket
{
    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this(action, slot, id, ItemStack.EMPTY);
    }

    public InventoryActionPacket(InventoryAction action, int slot, ItemStack slotItem) {
        this(action, slot, 0L, slotItem.copy());
        if (Platform.isClient() && action != InventoryAction.SET_FILTER) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
    }

    public static InventoryActionPacket decode(FriendlyByteBuf stream) {
        InventoryAction action = (InventoryAction)stream.readEnum(InventoryAction.class);
        int slot = stream.readInt();
        long extraId = stream.readLong();
        ItemStack slotItem = stream.readItem();
        return new InventoryActionPacket(action, slot, extraId, slotItem);
    }

    public void write(FriendlyByteBuf data) {
        data.writeEnum((Enum)this.action);
        data.writeInt(this.slot);
        data.writeLong(this.extraId);
        data.writeItem(this.slotItem);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AEBaseMenu) {
            AEBaseMenu baseMenu = (AEBaseMenu)abstractContainerMenu;
            if (this.action == InventoryAction.SET_FILTER) {
                baseMenu.setFilter(this.slot, this.slotItem);
            } else {
                baseMenu.doAction(player, this.action, this.slot, this.extraId);
            }
        }
    }
}

