/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.core.network.ServerboundPacket;
import appeng.helpers.IMouseWheelItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record MouseWheelPacket(boolean wheelUp) implements ServerboundPacket
{
    public static MouseWheelPacket decode(FriendlyByteBuf byteBuf) {
        boolean wheelUp = byteBuf.readBoolean();
        return new MouseWheelPacket(wheelUp);
    }

    public void write(FriendlyByteBuf data) {
        data.writeBoolean(this.wheelUp);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = mainHand.getItem();
        if (item instanceof IMouseWheelItem) {
            IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
            mouseWheelItem.onWheel(mainHand, this.wheelUp);
        } else {
            item = offHand.getItem();
            if (item instanceof IMouseWheelItem) {
                IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
                mouseWheelItem.onWheel(offHand, this.wheelUp);
            }
        }
    }
}

