/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.network.serverbound;

import appeng.core.network.ServerboundPacket;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public record SwitchGuisPacket(@Nullable MenuType<? extends ISubMenu> newGui) implements ServerboundPacket
{
    public static SwitchGuisPacket decode(FriendlyByteBuf stream) {
        MenuType newGui = null;
        if (stream.readBoolean()) {
            newGui = (MenuType)BuiltInRegistries.MENU.get(stream.readResourceLocation());
        }
        return new SwitchGuisPacket(newGui);
    }

    public void write(FriendlyByteBuf data) {
        if (this.newGui != null) {
            data.writeBoolean(true);
            data.writeResourceLocation(BuiltInRegistries.MENU.getKey(this.newGui));
        } else {
            data.writeBoolean(false);
        }
    }

    public static SwitchGuisPacket openSubMenu(MenuType<? extends ISubMenu> menuType) {
        return new SwitchGuisPacket(menuType);
    }

    public static SwitchGuisPacket returnToParentMenu() {
        return new SwitchGuisPacket((MenuType<? extends ISubMenu>)((MenuType)null));
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        if (this.newGui != null) {
            this.doOpenSubMenu(player);
        } else {
            this.doReturnToParentMenu(player);
        }
    }

    private void doOpenSubMenu(ServerPlayer player) {
        AEBaseMenu bc;
        MenuHostLocator locator;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AEBaseMenu && (locator = (bc = (AEBaseMenu)abstractContainerMenu).getLocator()) != null) {
            MenuOpener.open(this.newGui, (Player)player, locator);
        }
    }

    private void doReturnToParentMenu(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ISubMenu) {
            ISubMenu subMenu = (ISubMenu)abstractContainerMenu;
            subMenu.getHost().returnToMainMenu((Player)player, subMenu);
        }
    }
}

