/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEPatternHelper;
import appeng.crafting.pattern.PatternNbtUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AEProcessingPattern
implements IPatternDetails {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";
    public static final int MAX_INPUT_SLOTS = 81;
    public static final int MAX_OUTPUT_SLOTS = 27;
    private final AEItemKey definition;
    private final GenericStack[] sparseInputs;
    private final GenericStack[] sparseOutputs;
    private final Input[] inputs;
    private final GenericStack[] condensedOutputs;

    public AEProcessingPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.sparseInputs = PatternNbtUtils.getRequiredGenericStackList(tag, NBT_INPUTS, 81);
        this.sparseOutputs = PatternNbtUtils.getRequiredGenericStackList(tag, NBT_OUTPUTS, 27);
        GenericStack[] condensedInputs = AEPatternHelper.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new Input(condensedInputs[i]);
        }
        this.condensedOutputs = AEPatternHelper.condenseStacks(this.sparseOutputs);
    }

    public static void encode(CompoundTag tag, GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        if (Arrays.stream(sparseInputs).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("At least one input must be non-null.");
        }
        Objects.requireNonNull(sparseOutputs[0], "The first (primary) output must be non-null.");
        tag.put(NBT_INPUTS, (Tag)AEProcessingPattern.encodeStackList(sparseInputs));
        tag.put(NBT_OUTPUTS, (Tag)AEProcessingPattern.encodeStackList(sparseOutputs));
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEProcessingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.condensedOutputs;
    }

    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public GenericStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    @Override
    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        if (this.sparseInputs.length == this.inputs.length) {
            IPatternDetails.super.pushInputsToExternalInventory(inputHolder, inputSink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter counter : inputHolder) {
            allInputs.addAll(counter);
        }
        for (GenericStack sparseInput : this.sparseInputs) {
            if (sparseInput == null) continue;
            AEKey key = sparseInput.what();
            long amount = sparseInput.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new RuntimeException("Expected at least %d of %s when pushing pattern, but only %d available".formatted(amount, key, available));
            }
            inputSink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    public static PatternDetailsTooltip getInvalidPatternTooltip(CompoundTag tag, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_PRODUCES);
        PatternNbtUtils.getGenericStackListFaultTolerant(tag, NBT_INPUTS, tooltip::addInput);
        PatternNbtUtils.getGenericStackListFaultTolerant(tag, NBT_OUTPUTS, tooltip::addOutput);
        return tooltip;
    }

    private static ListTag encodeStackList(GenericStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (GenericStack stack : stacks) {
            tag.add((Object)GenericStack.writeTag(stack));
            if (stack == null || stack.amount() <= 0L) continue;
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        private Input(GenericStack stack) {
            this.template = new GenericStack[]{new GenericStack(stack.what(), 1L)};
            this.multiplier = stack.amount();
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        @Override
        public long getMultiplier() {
            return this.multiplier;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

